/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public final class LispDouble
extends LispReal {
    public static final LispDouble ZERO = new LispDouble(0.0);
    public static final LispDouble ONE = new LispDouble(1.0);
    public static final LispDouble POSITIVE_INFINITY = new LispDouble(Double.POSITIVE_INFINITY);
    public static final LispDouble NEGATIVE_INFINITY = new LispDouble(Double.NEGATIVE_INFINITY);
    public static final LispDouble NaN = new LispDouble(Double.NaN);
    private double number;

    public LispDouble(double x) {
        this.number = x;
    }

    public static LispReal toExact(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new LispNotSupportedException("err.notsupported.exactinfinity");
        }
        BigDecimal v = BigDecimal.valueOf(val);
        return LispUtils.bigDecimalToRational(v);
    }

    @Override
    public BigInteger getNumerator() {
        LispReal r = LispDouble.toExact(this.number);
        return r.getNumerator();
    }

    @Override
    public BigInteger getDenominator() {
        LispReal r = LispDouble.toExact(this.number);
        return r.getDenominator();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.number + c.getRealDouble(), c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number + x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.number - c.getRealDouble(), -c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number - x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (c.getRealDouble() == 0.0) {
                return LispComplex.newComplex(0.0, this.number * c.getImagDouble());
            }
            return LispComplex.newComplex(this.number * c.getRealDouble(), this.number * c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number * x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).getRealDouble();
            double xi = ((LispComplex)x).getImagDouble();
            if (xr == 0.0) {
                return LispComplex.newComplex(0.0, -this.number / xi);
            }
            return LispComplex.newComplex(this.number * xr / (xr * xr + xi * xi), -(this.number * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number / x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber uminus() {
        return new LispDouble(-this.number);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            return false;
        }
        if (x instanceof LispReal) {
            return this.number == x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return this.number < x.getRealDouble();
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return this.number > x.getRealDouble();
    }

    public BigInteger bigIntegerValue() {
        BigDecimal dec = new BigDecimal(this.number);
        return dec.toBigInteger();
    }

    public double doubleValue() {
        return this.number;
    }

    @Override
    public int signum() {
        return this.number > 0.0 ? 1 : (this.number < 0.0 ? -1 : 0);
    }

    @Override
    public LispNumber toExact() {
        return LispDouble.toExact(this.number);
    }

    @Override
    public LispNumber toInexact() {
        return this;
    }

    public boolean equals(Object x) {
        if (x instanceof LispDouble) {
            return this.number == ((LispDouble)x).number;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        long lr = Double.doubleToLongBits(this.number);
        l = 37 * l + (int)(lr ^ lr >>> 32);
        return l;
    }

    public String toString() {
        return Double.toString(this.number);
    }

    @Override
    public String print() {
        return LispDouble.disp(this.number);
    }

    @Override
    public String getResult() {
        return LispDouble.disp(this.number);
    }

    @Override
    public boolean isInteger() {
        return IntLispUtils.toIntegerExact(this.number) != null;
    }

    @Override
    public boolean isRational() {
        return !Double.isInfinite(this.number) && !Double.isNaN(this.number);
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (Double.isNaN(this.number)) {
            return new LispString("+nan.0");
        }
        if (this.number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (this.number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(Double.toString(this.number));
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return this.number == 1.0;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    @Override
    public int getInt() {
        return this.getBigInteger().intValue();
    }

    @Override
    public long getLong() {
        return this.getBigInteger().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            throw new NumberFormatException("Infinities or NaNs is not supported");
        }
        return BigDecimal.valueOf(this.number);
    }

    @Override
    public double getRealDouble() {
        return this.number;
    }

    @Override
    public LispType getType() {
        return LispType.REAL;
    }
}

