/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigInteger;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;
import net.morilib.lisp.sos.LispType;
import net.morilib.util.Inclementor;
import net.morilib.util.InclementorBoundsException;

public final class LispCharacter
extends Atom
implements Comparable<LispCharacter>,
Inclementor<LispCharacter> {
    public static final LispCharacter NEWLINE = new LispCharacter('\n');
    public static final LispCharacter SPACE = new LispCharacter(' ');
    private char character;

    public LispCharacter(char ch) {
        this.character = ch;
    }

    private static String getName(char ch) {
        if (ch == '\n') {
            return "newline";
        }
        if (ch == ' ') {
            return "space";
        }
        return Character.toString(ch);
    }

    public static LispCharacter getByName(String name) {
        if ("newline".equals(name)) {
            return NEWLINE;
        }
        if ("space".equals(name)) {
            return SPACE;
        }
        return null;
    }

    @Override
    public char getCharacter() {
        return this.character;
    }

    @Override
    public String getResult() {
        return "#\\" + LispCharacter.getName(this.character);
    }

    @Override
    public String print() {
        return Character.toString(this.character);
    }

    @Override
    public LispString toLispString() {
        return new LispString("#\\" + LispCharacter.getName(this.character));
    }

    public boolean equals(Object d) {
        if (d instanceof LispCharacter) {
            return this.character == ((LispCharacter)d).character;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.character;
        return l;
    }

    public String toString() {
        return Character.toString(this.character);
    }

    @Override
    public boolean isTypeCharacter() {
        return true;
    }

    @Override
    public int compareTo(LispCharacter o) {
        return this.character < o.character ? -1 : (this.character > o.character ? 1 : 0);
    }

    @Override
    public boolean equalIncliment(Inclementor<?> i) {
        if (i instanceof LispCharacter) {
            return this.character == ((LispCharacter)i).character;
        }
        return this.character == i.toInt();
    }

    @Override
    public boolean equalInt(int i) {
        return this.character == i;
    }

    @Override
    public LispCharacter getObject() {
        return this;
    }

    @Override
    public boolean isZero() {
        return this.character == '\u0000';
    }

    @Override
    public Inclementor<LispCharacter> suc() {
        if (this.character >= '\uffff') {
            throw new InclementorBoundsException();
        }
        return new LispCharacter((char)(this.character + '\u0001'));
    }

    @Override
    public Inclementor<LispCharacter> suc(int step) {
        if (this.character + step >= 65535) {
            throw new InclementorBoundsException();
        }
        return new LispCharacter((char)(this.character + '\u0001'));
    }

    @Override
    public int toInt() {
        return this.character;
    }

    @Override
    public boolean hasNext() {
        return this.character < '\uffff';
    }

    @Override
    public Inclementor<LispCharacter> getZero() {
        return new LispCharacter('\u0000');
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return i.equals(BigInteger.valueOf(this.character));
    }

    @Override
    public LispType getType() {
        return LispType.CHAR;
    }
}

