/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Settable;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class ExSubrSetter
extends UnaryArgs {
    private static final Setter INSTANCE = new Setter();

    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof Settable)) {
            throw mesg.getError("err.srfi17.required.settable", c1a);
        }
        return ((Settable)c1a).getSetter();
    }

    @Override
    public Datum getSetter() {
        Datum ss = super.getSetter();
        return ss == Undef.UNDEF ? INSTANCE : ss;
    }

    private static class Setter
    extends BinaryArgs {
        private Setter() {
            this.symbolName = "setter$setter";
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof Settable)) {
                throw mesg.getError("err.srfi17.required.settable", c1a);
            }
            if (!(c2a instanceof Procedure)) {
                throw mesg.getError("err.srfi17.required.procedure", c2a);
            }
            ((Settable)c1a).setSetter(c2a);
            return Undef.UNDEF;
        }
    }
}

