/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.math;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2010/11/21
 */
public final class Math2 {
	
	//
	private Math2() {}
	
	/**
	 * 
	 */
	public static final double EULER_CONSTANT =
		0.57721566490153286060651209008240243;
	
	/**
	 * 
	 */
	public static final double GOLDEN_RATIO =
		1.618033988749894848204586834365;
	
	/**
	 * 
	 */
	public static final int HARDY_RAMANUJAN_NUMBER = 1729;
	
	/**
	 * 
	 * @param n
	 * @return
	 */
	public static final int minus1ToThe(int n) {
		return ((n & 1) == 0) ? 1 : -1;
	}

	/**
	 * 
	 * @param alpha
	 * @return
	 */
	public static double decimalPart(double x) {
		double r = Math.IEEEremainder(x, 1.0);
		
		return (r < 0) ? 1 + r : r;
	}
	
	/**
	 * 
	 * @param x
	 * @return
	 */
	public static boolean isInteger(double x) {
		return decimalPart(x) == 0.0;
	}
	
}
