/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.Ranges;

public final class CharSets {
    public static final Range NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range ASCII_NUMBERS = CharSets.newCharInterval('0', '9');
    public static final Range CAPITAL_LETTERS = CharSets.newCharInterval('A', 'Z');
    public static final Range SMALL_LETTERS = CharSets.newCharInterval('a', 'z');
    public static final Range ENGLISH_ALPHABETS = Ranges.sum(CAPITAL_LETTERS, SMALL_LETTERS);
    public static final Range ENGLISH_ALPHABETS_NUMBERS = Ranges.sum(ENGLISH_ALPHABETS, ASCII_NUMBERS);
    public static final Range HIRAGANA = CharSets.newCharInterval('\u3041', '\u3094');
    public static final Range KATAKANA = CharSets.newCharInterval('\u30a1', '\u30fa');
    public static final Range SPACES = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));
    public static final Range TOKEN = Ranges.sum(IntervalsInt.newPoint(32), IntervalsInt.newPoint(9));

    private CharSets() {
    }

    public static final Range newCharInterval(char f, char t) {
        return IntervalsInt.newClosedInterval(f, t);
    }
}

