/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.dfa.DFA;
import net.morilib.automata.dfa.DFAState;
import net.morilib.automata.dfa.GraphDFA;
import net.morilib.automata.nfa.CombinedNFA;
import net.morilib.automata.nfa.NFAAccept;
import net.morilib.automata.nfa.NFABuilder;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.ParserSharpSyntax;
import net.morilib.lisp.Symbol;
import net.morilib.util.Inclimentor;
import net.morilib.util.IntInclimentor;
import net.morilib.util.Tuple2;

final class ParserSharpSyntaxImpl
extends ParserSharpSyntax {
    private List<NFAObject<Integer, Integer, Tuple2<Integer, Integer>>> nfas;
    private DFA<Integer, Integer, Tuple2<Integer, Integer>> dfa;
    private List<Datum> data = new ArrayList<Datum>();
    private BitSet follows = new BitSet();
    private BitSet usemt = new BitSet();
    private Inclimentor<Integer> inc;
    private NFABuilder<Integer> bld;
    private Map<String, Integer> patno = new HashMap<String, Integer>();

    ParserSharpSyntaxImpl() {
        this.inc = new IntInclimentor();
        this.bld = NFABuilder.newInstance(this.inc);
        this.nfas = new ArrayList<NFAObject<Integer, Integer, Tuple2<Integer, Integer>>>();
        this.addRule0("t", LispBoolean.TRUE, false, false);
        this.addRule0("f", LispBoolean.FALSE, false, false);
        this.addRule0("/.*/[iuc]*", Symbol.getSymbol("$compile-re"), false, true);
        this.dfa = GraphDFA.convertDFA(CombinedNFA.newInstance(this.nfas));
    }

    private void addRule0(String pattern, Datum d, boolean follow, boolean use) {
        Integer no;
        String pat = pattern;
        if (pat == null || d == null) {
            throw new NullPointerException();
        }
        if (pat.equals("")) {
            throw new IllegalArgumentException();
        }
        if (pat.charAt(0) == '#') {
            pat = pat.substring(1);
        }
        if ((no = this.patno.get(pat)) == null) {
            this.nfas.add(NFAAccept.newInstance(this.bld.parse(pat), this.inc.getObject()));
            this.data.add(d);
            this.follows.set((int)this.inc.getObject(), follow);
            this.usemt.set((int)this.inc.getObject(), use);
            this.patno.put(pat, this.inc.getObject());
            this.inc.suc();
        } else {
            this.nfas.set(no, NFAAccept.newInstance(this.bld.parse(pat), no));
            this.data.set(no, d);
            this.follows.set((int)no, follow);
            this.usemt.set((int)no, use);
        }
    }

    public ParserSharpSyntax.Engine getEngine() {
        return new Eng(this.dfa.getInitialState());
    }

    public void addRule(String pattern, Datum d, boolean follow, boolean use) {
        this.addRule0(pattern, d, follow, use);
        this.dfa = GraphDFA.convertDFA(CombinedNFA.newInstance(this.nfas));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Eng
    implements ParserSharpSyntax.Engine {
        private StringBuilder buf = new StringBuilder();
        private DFAState<Integer, Integer, Tuple2<Integer, Integer>> sta;

        private Eng(DFAState<Integer, Integer, Tuple2<Integer, Integer>> s) {
            this.sta = s;
        }

        private int getMt() {
            Set<Integer> mt = this.sta.getAccepted();
            int res = -1;
            for (Integer r : mt) {
                int n = res = res < 0 || res > r ? r : res;
            }
            return res;
        }

        @Override
        public Datum getDatum() {
            int mt = this.getMt();
            return mt < 0 ? null : (Datum)ParserSharpSyntaxImpl.this.data.get(mt);
        }

        @Override
        public boolean isFollowS() {
            int mt = this.getMt();
            return mt < 0 ? false : ParserSharpSyntaxImpl.this.follows.get(mt);
        }

        @Override
        public boolean isMatch() {
            return !this.sta.getAccepted().isEmpty();
        }

        @Override
        public boolean isUseMatch() {
            int mt = this.getMt();
            return mt < 0 ? false : ParserSharpSyntaxImpl.this.usemt.get(mt);
        }

        @Override
        public String getMatchString() {
            return this.buf.toString();
        }

        @Override
        public boolean isDead() {
            return this.sta.isDead();
        }

        @Override
        public void go(int c) {
            this.sta = this.sta.go(c);
            this.buf.append((char)c);
        }

        @Override
        public boolean isDeadNext(int c) {
            return this.sta.go(c).isDead();
        }
    }
}

