/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.io.IOException;
import java.io.InputStream;

public final class Utils {
	
	private Utils() {
		// do noting
	}
	
	
	public static void close(InputStream ins) {
		if(ins != null) {
			try {
				ins.close();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}


	public static boolean equals(Object o1, Object o2) {
		if(o1 == null) {
			return o2 == null;
		} else {
			return o1.equals(o2);
		}
	}
	
	
	public static int signum(int value) {
		return (value > 0) ? 1 : (value < 0) ? -1 : 0;
	}
	
	
	public static int gcd(int v1, int v2) {
		int x = (v1 < 0) ? -v1 : v1;
		int y = (v2 < 0) ? -v2 : v2;
		
		if(x == 0 && y == 0) {
			return 0;
		} else {
			while(y != 0) {
				int t = x % y;
				
				x = y;
				y = t;
			}
			return x;
		}
	}
	
	
	public static int natsub(int a, int b) {
		return (a - b) > 0 ? a - b : 0;
	}
	
	
	public static int tomult(int d, int m) {
		return (d / m) * m + signum(d % m) * m;
	}
	
	
	public static String printHash(Object o) {
		return (o == null) ? "0" : Integer.toString(o.hashCode(), 16);
	}
	
}
