/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;

import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispSmallInt;

/*package*/ class SubrUtils {
	
	
	/*package*/ static BigInteger ceil(BigInteger n, BigInteger d) {
		BigInteger v = n;
		
		if(v.compareTo(BigInteger.ZERO) > 0) {
			v = v.add(d);
		}
		return v.divide(d);
	}
	
	
	/*package*/ static BigInteger floor(BigInteger n, BigInteger d) {
		BigInteger v = n;
		
		if(v.compareTo(BigInteger.ZERO) < 0) {
			v = v.subtract(d);
		}
		return v.divide(d);
	}


	/*package*/ static Integer toIntExact(BigInteger i) {
		int r = i.intValue();
		
		if(i.equals(BigInteger.valueOf(r))) {
			return new Integer(r);
		} else {
			return null;
		}
	}


	/*package*/ static int getSmallIntegerExact(Datum d) {
		/*if(d instanceof LispInteger) {
			LispInteger li = (LispInteger)d;
			Integer i = SubrUtils.toIntExact(li.bigIntegerValue());
			
			if(i == null) {
				throw new LispException("small integer required");
			}
			return i.intValue();
		} else {
			throw new LispException("small integer required");
		}*/
		if(d instanceof LispSmallInt) {
			LispSmallInt li = (LispSmallInt)d;
			
			return li.getExactSmallInt();
		} else {
			throw new LispException("small integer required");
		}
	}
	
	
	/*package*/ static char getCharacter(Datum d) {
		if(d instanceof LispCharacter) {
			return ((LispCharacter)d).getCharacter();
		} else {
			throw new LispException("character required");
		}
	}
	
	
	
	
	
}
