/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;

import net.morilib.lisp.LispCompiler.MiscInfo;


public abstract class Syntax extends Datum {
	
	/*package*/ static final Symbol SYNTAX =
		Symbol.getSymbol("syntax");
	
	/*package*/ static final Symbol WITH_SYNTAX =
		Symbol.getSymbol("with-syntax");
	
	//
	protected String symbolName;
	
	
	public String getSymbolName() {
		return symbolName;
	}
	
	
	/*package*/ abstract void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist,
			CodeExecutor exec,
			IntStack memento,
			MiscInfo syncased);
	
	
	// ޥѤ̾(Ķ)ѰդƤΥ᥽åɤ¨֤
	/*package*/ abstract Datum replaceLocalVals(
			Datum body,
			Environment env,
			LispCompiler comp,
			Environment ienv,
			LispMessage mesg,
			boolean toplv, int ttype);
	
}
