/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;

import net.morilib.lisp.LispCompiler.MiscInfo;

public class SynLetrecSyntax
extends SynLetSyntaxBase implements SynLetType {
	
	/*package*/ String getName() {
		return "letrec-syntax";
	}
	
	/*package*/ LispException getError(LispMessage mesg) {
		return mesg.getError("err.letrecsyntax.malform");
	}
	
	/*package*/ void compile(
			Datum body,
			Environment env,
			LispCompiler comp,
			CompiledCode.Builder build,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			LispMessage mesg,
			List<Cons> symlist, CodeExecutor exec, IntStack memento, MiscInfo syncased) {
		if(body instanceof Cons) {
			CompiledCode.Builder nbuild = new CompiledCode.Builder();
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();
			List<Datum> lvars = new ArrayList<Datum>();
			List<Datum> lvals = new ArrayList<Datum>();
			Cons bnam = new Cons();
			
			// ŪClosure
			Environment  nenv = new Environment(env);
			
			// ѿ
			if(bcar instanceof Cons) {
				Datum d = bcar;
				
				// ѿɾ
				while(d != Nil.NIL) {
					if(d instanceof Cons) {
						List<Datum> l2;
						
						l2 = LispUtils.consToList(
								((Cons)d).getCar(), mesg);
						
						if(l2.size() != 2) {
							//throw new LispException(
							//		"syntax error: " + getName());
							throw getError(mesg);
						}
						
						// ѿͤΥꥹȤ
						lvars.add(l2.get(0));
						lvals.add(l2.get(1));
						
						d = ((Cons)d).getCdr();
					} else {
						//throw new LispException(
						//		"malformed " + getName());
						throw getError(mesg);
					}
				}
			} else {
				//throw new LispException("malformed " + getName());
				throw getError(mesg);
			}
			
			// 빽ʸ˹ʸХɤ
			for(int i = 0; i < lvars.size(); i++) {
				if(!(lvars.get(i) instanceof Symbol)) {
					//throw new LispException(
					//		"syntax name must be a symbol");
					throw mesg.getError("err.letrecsyntax.name");
				}
				
				Symbol name = (Symbol)lvars.get(i);
				//UserSyntax usyn = SyntaxUtils.processRuleDesc(
				//		name, lvals.get(i), nenv, true, mesg);
				UserSyntax usyn;
				if(SyntaxUtils.isSyntaxRules(lvals.get(i))) {
					usyn = SyntaxUtils.processRuleDesc(
							(Symbol)name, lvals.get(i), nenv,
							mesg, null);
				} else {
					// compile the sequence(list)
					CompiledCode.Builder mbuild =
						new CompiledCode.Builder();
					Environment menv = new Environment(nenv);
					Datum dz;
					
					//syncased.depth = 0;   // init depth
					usyn = new UserSyntax(
							((Symbol)name).getName(),
							env,
							mbuild.getCodeRef());
					dz = PatternMatch.appendScopeCase(
							lvals.get(i), usyn);
					comp.compile(
							dz, menv, nbuild,
							new Cons(), false, symlist,
							exec, memento, syncased);
					mbuild.addReturnOp();
				}
				
				// ξǹʸ
				nenv.bindDatum(name, usyn);
				
				// Ǽ¹ԴĶˤХɤ
				nbuild.addPush(usyn);
				nbuild.addBind(name);
			}
			
			// ꥹȤ򥳥ѥ뤹
			bnam.setCdr(LispUtils.listToCons(lvars));
			symlist.add(callsym);
			SyntaxUtils.compileList(
					bcdr, nenv, comp, nbuild,
					bnam, istail, mesg, symlist,
					exec, memento, syncased);
			symlist.remove(0);
			nbuild.addReturnOp();
			
			// ŪClosure
			ClosureClass cl = new ClosureClass(
					Nil.NIL, nbuild.getCodeRef());
			
			// ŪClosureƤӽФ
			build.addPush(cl);
			build.addBeginList();
			build.addEndList();
			build.addCall();
		} else {
			//throw new LispException("malformed " + getName());
			throw getError(mesg);
		}
	}
	
}
