/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArray<E>
extends AbstractList<E> {
    private Object[] array;

    public ObjectArray(int size) {
        this.array = new Object[size];
    }

    public ObjectArray(E[] array) {
        this.array = (Object[])array.clone();
    }

    public ObjectArray(Collection<E> col) {
        this(col.size());
        Iterator<E> iter = col.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.array[i] = iter.next();
            ++i;
        }
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return (E)this.array[index];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, Object element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        Object res = this.array[index];
        this.array[index] = element;
        return (E)res;
    }
}

