/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public abstract class NumCompare
extends Subr {
    protected abstract boolean compare(LispNumber var1, LispNumber var2, LispMessage var3);

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.argument", this.symbolName);
        }
        if (!(lst.get(0) instanceof LispNumber)) {
            throw mesg.getError("err.require.number", lst.get(0));
        }
        LispNumber prev = (LispNumber)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispNumber) {
                if (!this.compare(prev, (LispNumber)d, mesg)) {
                    return LispBoolean.FALSE;
                }
            } else {
                throw mesg.getError("err.require.number", d);
            }
            prev = (LispNumber)d;
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

