/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Atom;
import net.morilib.lisp.sos.LispType;

public final class LispString
extends Atom {
    public static final LispString EMPTY = new LispString("");
    private String value;

    public LispString(String value) {
        if (value == null) {
            throw new NullPointerException("string is null");
        }
        this.value = value;
    }

    public boolean isEqualTo(LispString a) {
        return this.value.equals(a.value);
    }

    public String getString() {
        return this.value;
    }

    void setString(String value) {
        this.value = value;
    }

    public LispString toLispString() {
        return this;
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public String print() {
        return this.value;
    }

    public String getResult() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else {
                b.append(c);
            }
            ++i;
        }
        return "\"" + b.toString() + "\"";
    }

    public boolean isTypeString() {
        return true;
    }

    public LispType getType() {
        return LispType.STRING;
    }
}

