/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

public final class CharBufferTape<T> implements Tape<T> {
	
	//
	private Stack2<T> buffer = new ArrayListStack<T>();
	
	
	public T read() {
		if(buffer.isEmpty()) {
			return null;
		} else {
			return buffer.peek();
		}
	}

	
	public boolean write(T symbol, Tape.Move mv) {
		if(mv == Tape.Move.LEFT) {
			if(buffer.isEmpty()) {
				return false;
			} else {
				buffer.pop();
				return true;
			}
		} else {
			if(symbol == null) {
				throw new NullPointerException();
			} else {
				buffer.add(symbol);
				return true;
			}
		}
	}
	
	
	public boolean isEmpty() {
		return buffer.isEmpty();
	}
	
}
