/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

/**
 * <i>USEful Implements</i> for arrays.<br>
 * ˴ؤʴؿǤ.
 * 
 * @author MORIGUCHI, Yuichiro 2004/12/18
 */
public final class Arrays2 {
	
	//
	private static final String DELIM = ", ";
	
	/**
	 * An empty array of int.
	 * <p>intǤ.
	 */
	public static final int[] INT_EMPTY = new int[0];
	
	/**
	 * An empty array of byte.
	 * <p>byteǤ.
	 */
	public static final byte[] BYTE_EMPTY = new byte[0];
	
	/**
	 * An empty array of short.
	 * <p>shortǤ.
	 */
	public static final short[] SHORT_EMPTY = new short[0];
	
	/**
	 * An empty array of long.
	 * <p>longǤ.
	 */
	public static final long[] LONG_EMPTY = new long[0];
	
	/**
	 * An empty array of char.
	 * <p>charǤ.
	 */
	public static final char[] CHAR_EMPTY = new char[0];
	
	/**
	 * An empty array of float.
	 * <p>floatǤ.
	 */
	public static final float[] FLOAT_EMPTY = new float[0];
	
	/**
	 * An empty array of double.
	 * <p>doubleǤ.
	 */
	public static final double[] DOUBLE_EMPTY = new double[0];
	
	/**
	 * An empty array of String.
	 * <p>StringǤ.
	 */
	public static final String[] STRING_EMPTY = new String[0];
	
	/**
	 * An empty array of Object.
	 * <p>ObjectǤ.
	 */
	public static final Object[] OBJECT_EMPTY = new Object[0];
	
	//
	private Arrays2() {}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(Object[] a1, Object[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(!Objects.equals(a1[i], a2[i])) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(int[] a1, int[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(long[] a1, long[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(short[] a1, short[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(byte[] a1, byte[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(char[] a1, char[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(float[] a1, float[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(double[] a1, double[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * returns true if the given arrays equals.
	 * <p>Ȥtrue.
	 * 
	 * @param a1  the first array to be compared
	 * @param a2  the second array to be compared
	 * @return  true if the given arrays equals
	 */
	public static boolean equals(boolean[] a1, boolean[] a2) {
		if(a1.length != a2.length) {
			return false;
		} else {
			for(int i = 0; i < a1.length; i++) {
				if(a1[i] != a2[i]) {
					return false;
				}
			}
			return true;
		}
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static Object[] copy(
			Object[] src, int begin, int end, Object[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static Object[] copy(Object[] src, int begin, int end) {
		return copy(src, begin, end, new Object[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static Object[] copy(Object[] src, Object[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static Object[] copy(Object[] src) {
		return copy(src, new Object[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static boolean[] copy(
			boolean[] src, int begin, int end, boolean[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static boolean[] copy(boolean[] src, int begin, int end) {
		return copy(src, begin, end, new boolean[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static boolean[] copy(boolean[] src, boolean[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static boolean[] copy(boolean[] src) {
		return copy(src, 0, src.length - 1, new boolean[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static byte[] copy(
			byte[] src, int begin, int end, byte[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static byte[] copy(byte[] src, int begin, int end) {
		return copy(src, begin, end, new byte[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static byte[] copy(byte[] src, byte[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static byte[] copy(byte[] src) {
		return copy(src, 0, src.length - 1, new byte[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static char[] copy(
			char[] src, int begin, int end, char[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static char[] copy(char[] src, int begin, int end) {
		return copy(src, begin, end, new char[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static char[] copy(char[] src, char[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static char[] copy(char[] src) {
		return copy(src, 0, src.length - 1, new char[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static short[] copy(
			short[] src, int begin, int end, short[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static short[] copy(short[] src, int begin, int end) {
		return copy(src, begin, end, new short[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static short[] copy(short[] src, short[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static short[] copy(short[] src) {
		return copy(src, 0, src.length - 1, new short[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static int[] copy(int[] src, int begin, int end, int[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static int[] copy(int[] src, int begin, int end) {
		return copy(src, begin, end, new int[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static int[] copy(int[] src, int[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static int[] copy(int[] src) {
		return copy(src, 0, src.length - 1, new int[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static long[] copy(
			long[] src, int begin, int end, long[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static long[] copy(long[] src, int begin, int end) {
		return copy(src, begin, end, new long[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static long[] copy(long[] src, long[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static long[] copy(long[] src) {
		return copy(src, 0, src.length - 1, new long[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static float[] copy(
			float[] src, int begin, int end, float[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static float[] copy(float[] src, int begin, int end) {
		return copy(src, begin, end, new float[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static float[] copy(float[] src, float[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static float[] copy(float[] src) {
		return copy(src, 0, src.length - 1, new float[src.length]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static double[] copy(
			double[] src, int begin, int end, double[] dst) {
		System.arraycopy(src, begin, dst, 0, end - begin + 1);
		return dst;
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param begin the starting index in the source array
	 * @param end   the ending index in the source array
	 * @return  a clone of the source array
	 */
	public static double[] copy(double[] src, int begin, int end) {
		return copy(src, begin, end, new double[end - begin + 1]);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @param dst   the destination array
	 * @return  the given destination array
	 */
	public static double[] copy(double[] src, double[] dst) {
		return copy(src, 0, src.length - 1, dst);
	}
	
	/**
	 * copies the given source array to the given destination array.
	 * <p>򥳥ԡ.
	 * 
	 * @param src   the source array
	 * @return  a clone of the source array
	 */
	public static double[] copy(double[] src) {
		return copy(src, 0, src.length - 1, new double[src.length]);
	}
	
	/**
	 * returns true if the all elements of the given array is null.
	 * <p>ǤnullΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isAllNull(Object[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != null) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is false.
	 * <p>ǤfalseΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is false
	 */
	public static boolean isAllFalse(boolean[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i]) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is true.
	 * <p>ǤtrueΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is true
	 */
	public static boolean isAllTrue(boolean[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(!arr[i]) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(byte[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0)
				return false;
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(short[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0)
				return false;
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(int[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0)
				return false;
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(long[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0)
				return false;
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(float[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0)
				return false;
		}
		return true;
	}
	
	/**
	 * returns true if the all elements of the given array is zero.
	 * <p>Ǥ0ΤȤtrue.
	 * 
	 * @param arr  the array to be tested
	 * @return  if the all elements of the given array is null
	 */
	public static boolean isEmpty(double[] arr) {
		for(int i = 0; i < arr.length; i++) {
			if(arr[i] != 0.0)
				return false;
		}
		return true;
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static Object[] resize(Object[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			Object[] res = new Object[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static boolean[] resize(boolean[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			boolean[] res = new boolean[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static byte[] resize(byte[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			byte[] res = new byte[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static char[] resize(char[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			char[] res = new char[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static short[] resize(short[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			short[] res = new short[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static int[] resize(int[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			int[] res = new int[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static long[] resize(long[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			long[] res = new long[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static float[] resize(float[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			float[] res = new float[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * resizes the given array to the given size; if size of
	 * the array is not smaller than the given size, this method returns
	 * the given one simply.
	 * <p>ꥵ.ΥꥵΥʾΤȤ
	 * 򤽤Τޤ֤.
	 * 
	 * @param src   the array to be resized
	 * @param size  the size after resized
	 * @return  the resized array
	 */
	public static double[] resize(double[] src, int size) {
		if(src.length >= size) {
			return src;
		} else {
			double[] res = new double[size];
			
			System.arraycopy(src, 0, res, 0, src.length);
			return res;
		}
	}
	
	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(Object[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Objects.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(boolean[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Boolean.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(byte[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Byte.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(char[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Character.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(short[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Short.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(int[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Integer.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(long[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Long.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(float[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Float.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}

	/**
	 * returns the string representation of the given array.
	 * <p>ʸɽ.
	 * 
	 * @param a  the array
	 * @return  the string representation of the array
	 */
	public static String toString(double[] a) {
		StringBuffer buf = new StringBuffer();
		String d2 = "";
		
		for(int i = 0; i < a.length; i++) {
			buf.append(d2);
			buf.append(Double.toString(a[i]));
			d2 = DELIM;
		}
		return buf.toString();		
	}
	
	/**
	 * returns true if the given array contains an null pointer.
	 * <p>Ǥ˥̥뤬ޤޤȤtrue.
	 * 
	 * @param a  the array
	 * @return  true if the given array contains an null pointer
	 */
	public static boolean containsNull(Object[] a) {
		for(int i = 0; i < a.length; i++) {
			if(a[i] == null) {
				return true;
			}
		}
		return false;
	}
	
}
