/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import net.morilib.lisp.sos.LispType;

/*package*/ class SymbolScope extends Datum implements SymbolName {
	
	//
	private Symbol symbol;
	private UserSyntax scope;
	private boolean captured = false;
	
	
	/*package*/ SymbolScope(
			Symbol symbol, UserSyntax scope, boolean cap) {
		if(symbol == null || scope == null) {
			throw new NullPointerException();
		}
		this.symbol = symbol;
		this.scope = scope;
		this.captured = cap;
	}
	
	
	/*package*/ SymbolScope(Symbol symbol, UserSyntax scope) {
		this(symbol, scope, false);
	}

	/**
	 * @return the symbol
	 */
	public Symbol getSymbol() {
		return symbol;
	}
	
	
	public UserSyntax getUserSyntax() {
		return scope;
	}
	
	
	public Environment getExecuteEnv(Environment eenv) {
		if(scope.getRootSyntax() != null) {
			Environment s2 =
				scope.getRootSyntax().getExecuteEnv();
			
			if(s2 != null) {
				return s2;
			} else {
				throw new RuntimeException(
						"environment has not been initialized");
			}
			//return eenv;
		} else if(scope.getExecuteEnv() == null) {
			throw new RuntimeException(
					"environment has not been initialized");
		}
		return scope.getExecuteEnv();
	}
	
	
	public String toString() {
		return symbol + ":" + scope;
	}
	
	
	public boolean isTypeSymbol() {
		return true;
	}

	
	public String getName() {
		return symbol.getName();
	}
	
	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getType()
	 */
	@Override
	public LispType getType() {
		return LispType.SYMBOL;
	}
	
	
	public boolean isCaptured() {
		return captured;
	}
	
}
