/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import net.morilib.lisp.sos.LispType;

public abstract class LispReal extends LispNumber
implements Comparable<LispReal> {
	
	
	public LispReal getReal() {
		return this;
	}
	
	
	public double getImagDouble() {
		return 0.0;
	}
	
	
	public LispReal getImag() {
		if(isNaN()) {
			return LispDouble.NaN;
		} else if(isExact()) {
			return LispInteger.ZERO;
		} else {
			return LispDouble.ZERO;
		}
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(LispReal o) {
		return isLessThan(o) ? -1 : (isMoreThan(o) ? 1 : 0);
	}


	public abstract boolean isLessThan(LispReal x);
	
	
	public abstract boolean isMoreThan(LispReal x);
	
	
	public abstract int signum();
	
	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#getType()
	 */
	@Override
	public LispType getType() {
		return LispType.REAL;
	}
	
}
