/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;
import java.util.Set;

/*package*/ final class UserSyntax extends Datum implements ExecuteEnvScope {
	
	//
	private String name;                  // 󥿥å̾
	private List<Datum> patternList;      // ѥΥꥹ
	private List<Datum> templateList;     // ƥץ졼ȤΥꥹ
	private List<Set<Symbol>> paramList;  // ѥ᡼Υꥹ
	private Set<Symbol> reservedSet;      // ͽΥꥹ
	private Environment compileEnv;       // ѥδĶ
	private boolean definedLetSyntax;     // let-syntax줿
	
	// ¹ԻδĶ(let-syntax줿ȤΤ߻)
	private Environment executeEnv = null;
	
	/*package*/ UserSyntax(
			String name,
			List<Datum> patlist,
			List<Datum> tmplist,
			List<Set<Symbol>> paramList,
			Set<Symbol> reserved,
			Environment compileEnv,
			boolean definedLetSyntax) {
		if(name == null || patlist == null ||
				tmplist == null || reserved == null) {
			throw new NullPointerException();
		}
		
		this.name = name;
		this.patternList = patlist;
		this.templateList = tmplist;
		this.paramList = paramList;
		this.reservedSet = reserved;
		this.compileEnv = compileEnv;
		this.definedLetSyntax = definedLetSyntax;
	}


	/**
	 * @return the patternList
	 */
	public List<Datum> getPatternList() {
		return patternList;
	}


	/**
	 * @return the templateList
	 */
	public List<Datum> getTemplateList() {
		return templateList;
	}


	/**
	 * @return the reservedSet
	 */
	public Set<Symbol> getReservedSet() {
		return reservedSet;
	}


	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}


	/**
	 * @return the paramList
	 */
	public List<Set<Symbol>> getParamList() {
		return paramList;
	}


	/**
	 * @return the compileEnv
	 */
	public Environment getCompileEnv() {
		return compileEnv;
	}


	/**
	 * @return the definedLetSyntax
	 */
	public boolean isDefinedLetSyntax() {
		return definedLetSyntax;
	}


	/**
	 * @return the executeEnv
	 */
	public Environment getExecuteEnv() {
		return executeEnv;
	}


	/*package*/ void setExecuteEnv(Environment executeEnv) {
		this.executeEnv = executeEnv;
	}
	
	
}
