/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynQuasiquote
extends Syntax {
    private static Datum getCaar(Cons c) {
        if (c.getCar() instanceof Cons) {
            return ((Cons)c.getCar()).getCar();
        }
        return null;
    }

    private static boolean equalsQuasiquote(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.QUASIQUOTE, d);
    }

    private static boolean equalsUnquote(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.UNQUOTE, d);
    }

    private static boolean equalsUnquoteSplicing(Datum d) {
        return SyntaxUtils.equalsReserved(Symbol.UNQUOTE_SPLICING, d);
    }

    public String toString() {
        return "Syntax:quasiquote";
    }

    private void quote1(int level, Cons c, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist) {
        if (!(c.getCdr() instanceof Cons)) {
            throw mesg.getError("err.quasiquote.malform");
        }
        Cons c2 = (Cons)c.getCdr();
        build.addBeginList();
        build.addPush(c.getCar());
        build.addAppendList();
        this.expand(level, c2.getCar(), env, comp, build, callsym, mesg, symlist);
        build.addAppendList();
        build.addEndList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void expand(int level, Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist) {
        if (body instanceof Cons) {
            Datum caar;
            Cons c = (Cons)body;
            if (SynQuasiquote.equalsQuasiquote(c.getCar())) {
                this.quote1(level + 1, c, env, comp, build, callsym, mesg, symlist);
                return;
            }
            if (SynQuasiquote.equalsUnquote(c.getCar())) {
                if (level > 0) {
                    this.quote1(level - 1, c, env, comp, build, callsym, mesg, symlist);
                    return;
                } else {
                    if (!(c.getCdr() instanceof Cons)) throw mesg.getError("err.quasiquote.malform");
                    Cons c2 = (Cons)c.getCdr();
                    comp.compile(c2.getCar(), env, build, callsym, false, symlist);
                }
                return;
            }
            if (SynQuasiquote.equalsUnquoteSplicing(c.getCar())) {
                if (level > 0) {
                    this.quote1(level - 1, c, env, comp, build, callsym, mesg, symlist);
                    return;
                } else {
                    if (!(c.getCdr() instanceof Cons)) throw mesg.getError("err.quasiquote.malform");
                    Cons c2 = (Cons)c.getCdr();
                    comp.compile(c2.getCar(), env, build, callsym, false, symlist);
                }
                return;
            }
            build.addBeginList();
            while (true) {
                caar = SynQuasiquote.getCaar(c);
                this.expand(level, c.getCar(), env, comp, build, callsym, mesg, symlist);
                if (!(c.getCdr() instanceof Cons)) break;
                Cons c2 = (Cons)c.getCdr();
                Datum d2 = c2.getCar();
                if (SynQuasiquote.equalsUnquote(d2)) {
                    if (SynQuasiquote.equalsUnquoteSplicing(caar)) {
                        build.addAppendListSplicing();
                    } else {
                        build.addAppendList();
                    }
                    this.expand(level, c.getCdr(), env, comp, build, callsym, mesg, symlist);
                    build.addEndListDot();
                    return;
                }
                if (SynQuasiquote.equalsUnquoteSplicing(d2)) {
                    throw mesg.getError("err.quasiquote.malform");
                }
                if (level == 0 && SynQuasiquote.equalsUnquoteSplicing(caar)) {
                    build.addAppendListSplicing();
                    c = (Cons)c.getCdr();
                    continue;
                }
                build.addAppendList();
                c = (Cons)c.getCdr();
            }
            if (c.getCdr() == Nil.NIL) {
                if (level == 0 && SynQuasiquote.equalsUnquoteSplicing(caar)) {
                    build.addEndListDot();
                    return;
                } else {
                    build.addAppendList();
                    build.addEndList();
                }
                return;
            } else {
                if (level == 0 && SynQuasiquote.equalsUnquoteSplicing(caar)) {
                    build.addAppendListSplicing();
                } else {
                    build.addAppendList();
                }
                this.expand(level, c.getCdr(), env, comp, build, callsym, mesg, symlist);
                build.addEndListDot();
            }
            return;
        }
        if (body instanceof LispVector) {
            LispVector v = (LispVector)body;
            build.addBeginList();
            int i = 0;
            while (i < v.size()) {
                this.expand(level, v.get(i), env, comp, build, callsym, mesg, symlist);
                if (v.get(i) instanceof Cons) {
                    Cons cz = (Cons)v.get(i);
                    if (SynQuasiquote.equalsUnquoteSplicing(cz.getCar())) {
                        build.addAppendListSplicing();
                    } else {
                        build.addAppendList();
                    }
                } else {
                    build.addAppendList();
                }
                ++i;
            }
            build.addEndListVector();
            return;
        } else {
            build.addPush(body);
        }
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        if (!(body instanceof Cons)) {
            throw mesg.getError("err.quasiquote.malform");
        }
        this.expand(0, ((Cons)body).getCar(), env, comp, build, callsym, mesg, symlist);
    }

    private Datum quoteE1(int level, Cons c, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg) {
        Cons c2 = (Cons)c.getCdr();
        Cons res = new Cons();
        Cons r2 = new Cons();
        res.setCar(c.getCar());
        res.setCdr(r2);
        r2.setCar(this.extract1(level, c2.getCar(), env, comp, ienv, mesg));
        return res;
    }

    private Datum extract1(int level, Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg) {
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            if (SynQuasiquote.equalsQuasiquote(c.getCar())) {
                return this.quoteE1(level + 1, c, env, comp, ienv, mesg);
            }
            if (SynQuasiquote.equalsUnquote(c.getCar())) {
                if (level > 0) {
                    return this.quoteE1(level - 1, c, env, comp, ienv, mesg);
                }
                if (c.getCdr() instanceof Cons) {
                    Cons c2 = (Cons)c.getCdr();
                    Cons r1 = new Cons();
                    Cons r2 = new Cons();
                    r1.setCar(c.getCar());
                    r1.setCdr(r2);
                    r2.setCar(comp.replaceLocalVals(c2.getCar(), env, ienv, false));
                    return r1;
                }
                throw mesg.getError("err.quasiquote.malform");
            }
            if (SynQuasiquote.equalsUnquoteSplicing(c.getCar())) {
                if (level > 0) {
                    return this.quoteE1(level - 1, c, env, comp, ienv, mesg);
                }
                if (c.getCdr() instanceof Cons) {
                    Cons c2 = (Cons)c.getCdr();
                    Cons r1 = new Cons();
                    Cons r2 = new Cons();
                    r1.setCar(c.getCar());
                    r1.setCdr(r2);
                    r2.setCar(comp.replaceLocalVals(c2.getCar(), env, ienv, false));
                    return r1;
                }
                throw mesg.getError("err.quasiquote.malform");
            }
            ArrayList<Datum> lst = new ArrayList<Datum>();
            while (true) {
                Datum caar = SynQuasiquote.getCaar(c);
                lst.add(this.extract1(level, c.getCar(), env, comp, ienv, mesg));
                if (!(c.getCdr() instanceof Cons)) break;
                Cons c2 = (Cons)c.getCdr();
                Datum d2 = c2.getCar();
                if (SynQuasiquote.equalsUnquote(d2)) {
                    Datum dz = this.extract1(level, c.getCdr(), env, comp, ienv, mesg);
                    return LispUtils.listToCons(lst, dz);
                }
                if (SynQuasiquote.equalsUnquoteSplicing(d2)) {
                    throw mesg.getError("err.quasiquote.malform");
                }
                if (level == 0 && SynQuasiquote.equalsUnquoteSplicing(caar)) {
                    c = (Cons)c.getCdr();
                    continue;
                }
                c = (Cons)c.getCdr();
            }
            if (c.getCdr() == Nil.NIL) {
                return LispUtils.listToCons(lst);
            }
            return LispUtils.listToCons(lst, this.extract1(level, c.getCdr(), env, comp, ienv, mesg));
        }
        if (body instanceof LispVector) {
            ArrayList<Datum> lst = new ArrayList<Datum>();
            LispVector v = (LispVector)body;
            int i = 0;
            while (i < v.size()) {
                lst.add(this.extract1(level, v.get(i), env, comp, ienv, mesg));
                ++i;
            }
            return new LispVector(lst);
        }
        return body;
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        if (body instanceof Cons) {
            Cons res = new Cons();
            res.setCar(this.extract1(0, ((Cons)body).getCar(), env, comp, ienv, mesg));
            return res;
        }
        throw mesg.getError("err.quasiquote.malform");
    }
}

