/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynLambda
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        Datum bcdr;
        Cons c;
        if (body instanceof Cons) {
            c = (Cons)body;
            bcdr = c.getCdr();
            if (!SyntaxUtils.isValidSymbolList(c.getCar())) {
                throw mesg.getError("err.parameters", c.getCar());
            }
        } else {
            throw mesg.getError("err.lambda.malform");
        }
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(menv);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, new Cons(), true, mesg, new ArrayList<Cons>());
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(c.getCar(), nbuild.getCodeRef());
        mbuild.addPush(cln);
        mbuild.addReturnOp();
        ClosureClass clm = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(clm);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            Datum bcdr = c.getCdr();
            Cons res = new Cons();
            Environment nenv = new Environment(ienv);
            res.setCar(SyntaxUtils.addLocalValsAll(nenv, c.getCar(), mesg));
            res.setCdr(SyntaxUtils.replaceLocalValsList(bcdr, env, comp, nenv, mesg));
            return res;
        }
        throw mesg.getError("err.lambda.malform");
    }
}

