/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynDefine
extends Syntax {
    private void defun(Datum bcar, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, List<Cons> symlist, boolean toplevel) {
        Cons c = (Cons)bcar;
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        Environment menv = new Environment(env);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(menv);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, c, true, mesg, new ArrayList<Cons>());
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(c.getCdr(), nbuild.getCodeRef());
        mbuild.addPush(cln);
        mbuild.addReturnOp();
        ClosureClass clm = new ClosureClass(Nil.NIL, mbuild.getCodeRef());
        build.addPush(clm);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBind(c.getCar());
        build.addPush(Undef.UNDEF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        if (!(body instanceof Cons)) throw mesg.getError("err.define.malform");
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        if (bcar instanceof Cons) {
            Datum cz = ((Cons)bcar).getCar();
            if (!(cz instanceof Symbol) && !(cz instanceof SymbolScope)) {
                throw mesg.getError("err.define.malform");
            }
            this.defun(bcar, bcdr, env, comp, build, callsym, mesg, symlist, toplevel);
            return;
        } else {
            if (!(bcar instanceof Symbol) && !(bcar instanceof SymbolScope)) throw mesg.getError("err.define.malform");
            SyntaxUtils.compileBind(bcar, bcdr, env, comp, build, callsym, toplevel, mesg, "err.define.malform", new ArrayList<Cons>());
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof Cons) {
                Cons c = (Cons)bcar;
                Cons res = new Cons();
                Cons arg = new Cons();
                Environment nenv = new Environment(ienv);
                res.setCar(arg);
                arg.setCdr(SyntaxUtils.addLocalValsAll(nenv, c.getCdr(), mesg));
                res.setCdr(SyntaxUtils.replaceLocalValsList(bcdr, env, comp, nenv, mesg));
                if (!toplv) {
                    arg.setCar(SyntaxUtils.putSymbol(ienv, c.getCar(), mesg));
                } else {
                    arg.setCar(c.getCar());
                }
                return res;
            }
            if (bcar instanceof Symbol || bcar instanceof SymbolScope) {
                Cons res = new Cons();
                res.setCdr(comp.replaceLocalVals(bcdr, env, ienv, false));
                if (!toplv) {
                    res.setCar(SyntaxUtils.putSymbol(ienv, bcar, mesg));
                } else if (bcar instanceof Symbol) {
                    res.setCar(bcar);
                } else {
                    res.setCar(((SymbolScope)bcar).getSymbol());
                }
                return res;
            }
            throw mesg.getError("err.define.malform");
        }
        throw mesg.getError("err.define.malform");
    }
}

