/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;

public final class LispBoolean
extends Atom {
    private boolean value;
    public static final LispBoolean TRUE = new LispBoolean(true);
    public static final LispBoolean FALSE = new LispBoolean(false);

    public static LispBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    private LispBoolean(boolean value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o instanceof LispBoolean) {
            return this.value == ((LispBoolean)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return this.value ? "#t" : "#f";
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    public boolean getValue() {
        return this.value;
    }

    public String print() {
        return this.value ? "#t" : "#f";
    }

    public String getResult() {
        return this.value ? "#t" : "#f";
    }

    public LispString toLispString() {
        return new LispString(this.value ? "#t" : "#f");
    }

    public boolean isTypeBoolean() {
        return true;
    }

    public boolean isTrue() {
        return this.value;
    }
}

