/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispException;
import net.morilib.lisp.Symbol;

public final class Environment {
    private Environment rootenv;
    private Map<Symbol, Datum> binds = Collections.synchronizedMap(new HashMap());

    Environment() {
        this.rootenv = null;
    }

    Environment(Environment rootenv) {
        this.rootenv = rootenv;
    }

    public void bindDatum(Datum sym, Datum d) {
        if (!(sym instanceof Symbol)) {
            throw new LispException("Parameter is not a symbol");
        }
        this.binds.put((Symbol)sym, d);
    }

    public Datum findDatum(Datum sym) {
        if (sym instanceof Symbol) {
            Environment env = this;
            while (env != null) {
                Datum f = env.binds.get(sym);
                if (f != null) {
                    return f;
                }
                env = env.rootenv;
            }
            return null;
        }
        throw new LispException("Parameter is not a symbol");
    }

    boolean setDatum(Datum sym, Datum d) {
        if (sym instanceof Symbol) {
            Environment env = this;
            while (env != null) {
                Datum f = env.binds.get(sym);
                if (f != null) {
                    env.binds.put((Symbol)sym, d);
                    return true;
                }
                env = env.rootenv;
            }
            return false;
        }
        throw new LispException("Parameter is not a symbol");
    }

    Environment getGlobal() {
        Environment env = this;
        while (env.rootenv != null) {
            env = env.rootenv;
        }
        return env;
    }

    Environment getRootenv() {
        return this.rootenv;
    }

    Environment copy() {
        Environment res = new Environment();
        res.rootenv = this.rootenv;
        res.binds = new HashMap<Symbol, Datum>(this.binds);
        return res;
    }

    Environment copyNotRoot() {
        return this.rootenv != null ? this.copy() : this;
    }

    public String toString() {
        Environment env = this;
        StringBuilder buf = new StringBuilder();
        while (env.rootenv != null) {
            buf.append(env.binds).append("->");
            env = env.rootenv;
        }
        buf.append("{Global}");
        return buf.toString();
    }
}

