/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import net.morilib.lisp.util.Stack2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListStack<E>
implements Stack2<E> {
    ArrayList<E> list = new ArrayList();

    @Override
    public E push(E o) {
        this.list.add(o);
        return o;
    }

    @Override
    public E pop() {
        if (this.list.size() <= 0) {
            throw new EmptyStackException();
        }
        return this.list.remove(this.list.size() - 1);
    }

    @Override
    public E peek() {
        if (this.list.size() <= 0) {
            throw new EmptyStackException();
        }
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public E get(int n) {
        return this.list.get(n);
    }

    @Override
    public boolean isEmpty() {
        return this.list.size() <= 0;
    }

    @Override
    public void pop(int n) {
        if (this.list.size() < n) {
            throw new IndexOutOfBoundsException();
        }
        int size = this.list.size();
        int i = 1;
        while (i <= n) {
            this.list.remove(size - i);
            ++i;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(E o) {
        return this.list.contains(o);
    }

    @Override
    public List<E> toList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public boolean add(E o) {
        return this.list.add(o);
    }

    @Override
    public void addAll(Stack2<E> s) {
        this.list.addAll(s.toList());
    }

    public String toString() {
        return this.list.toString();
    }
}

