/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternDepthException;
import net.morilib.lisp.PatternDepthMap;
import net.morilib.lisp.PatternEllipsisException;
import net.morilib.lisp.PatternMatch;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Undef;
import net.morilib.lisp.UserSyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SyntaxUtils {
    private static final Symbol SYNTAX_RULES = Symbol.getSymbol("syntax-rules");

    private SyntaxUtils() {
    }

    /*
     * Unable to fully structure code
     */
    static boolean isValidSymbolList(Datum d) {
        p = d;
        if (!d.isTypeSymbol()) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            if (p instanceof Cons) {
                c = (Cons)p;
                if (!c.getCar().isTypeSymbol()) {
                    return false;
                }
                p = c.getCdr();
                continue;
            }
            return p.isTypeSymbol();
lbl11:
            // 2 sources

            ** while (p != Nil.NIL)
        }
lbl12:
        // 1 sources

        return true;
    }

    static void compileBind(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, boolean toplevel, LispMessage mesg, String ercd, List<Cons> symlist) {
        if (bcdr instanceof Cons) {
            Datum d1 = ((Cons)bcdr).getCar();
            CompiledCode.Builder nbuild = new CompiledCode.Builder();
            Environment nenv = new Environment(env);
            comp.compile(d1, nenv, nbuild, callsym, true, new ArrayList<Cons>());
            nbuild.addReturnOp();
            ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
            build.addPush(cl);
            build.addBeginList();
            build.addEndList();
            build.addCall();
            if (toplevel) {
                Symbol r;
                if (sym instanceof Symbol) {
                    r = ((Symbol)sym).getEnclosedSymbol();
                } else {
                    r = ((SymbolScope)sym).getSymbol();
                    r = r.getEnclosedSymbol();
                }
                build.addBind(r);
                build.addPush(sym);
            } else {
                build.addBind(sym);
                build.addPush(Undef.UNDEF);
            }
        } else {
            throw mesg.getError(ercd);
        }
    }

    static void compileBindMacro(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, String ercd, List<Cons> symlist) {
        if (!(bcdr instanceof Cons)) {
            throw mesg.getError(ercd);
        }
        Datum d1 = ((Cons)bcdr).getCar();
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(env);
        comp.compile(d1, nenv, build, callsym, true, new ArrayList<Cons>());
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBindMacro(sym);
        build.addPush(Undef.UNDEF);
    }

    static void compileList(Datum b, Environment env, LispCompiler comp, CompiledCode.Builder nbuild, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        Datum bcdr = b;
        nbuild.addPush(Undef.UNDEF);
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                Cons bc = (Cons)bcdr;
                boolean tl = istail && bc.getCdr() == Nil.NIL;
                nbuild.addPop();
                comp.compile(bc.getCar(), env, nbuild, callsym, tl, symlist);
                bcdr = bc.getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
    }

    static void compileListApply(Datum b, Environment env, LispCompiler comp, CompiledCode.Builder nbuild, Cons callsym, LispMessage mesg, List<Cons> symlist) {
        Datum bcdr = b;
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                Cons bc = (Cons)bcdr;
                comp.compile(bc.getCar(), env, nbuild, callsym, false, symlist);
                nbuild.addAppendList();
                bcdr = bc.getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
    }

    static Datum replaceLocalValsList(Datum b, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg) {
        Datum bcdr = b;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                lst.add(comp.replaceLocalVals(((Cons)bcdr).getCar(), env, ienv, false));
                bcdr = ((Cons)bcdr).getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
        return LispUtils.listToCons(lst);
    }

    static Symbol putSymbol(Environment ienv, Datum p, LispMessage mesg) {
        if (p instanceof Symbol) {
            Symbol res = Symbol.encloseSymbol((Symbol)p);
            ienv.bindDatum(p, res);
            return res;
        }
        if (p instanceof SymbolScope) {
            Symbol s = ((SymbolScope)p).getSymbol();
            Symbol res = Symbol.encloseSymbol(s);
            ienv.bindDatum(s, res);
            return res;
        }
        throw mesg.getError("err.symbol");
    }

    static Datum addLocalValsAll(Environment ienv, Datum d, LispMessage mesg) {
        Datum p = d;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        while (p != Nil.NIL) {
            if (p instanceof Cons) {
                Symbol r = SyntaxUtils.putSymbol(ienv, ((Cons)p).getCar(), mesg);
                p = ((Cons)p).getCdr();
                lst.add(r);
                continue;
            }
            return LispUtils.listToCons(lst, SyntaxUtils.putSymbol(ienv, p, mesg));
        }
        return LispUtils.listToCons(lst);
    }

    private static void processRule(Symbol name, Datum body, List<Datum> pat, List<Datum> tmp, List<Set<Symbol>> stl, Set<Symbol> reserve, LispMessage mesg) {
        Datum ptd;
        List<Datum> lst = LispUtils.consToList(body, mesg);
        HashSet<Symbol> st = new HashSet<Symbol>();
        PatternDepthMap mpp = new PatternDepthMap();
        PatternDepthMap mpt = new PatternDepthMap();
        if (lst.size() != 2) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        if (lst.get(0) instanceof Cons) {
            Cons l0 = (Cons)lst.get(0);
            if (!(l0 instanceof Cons)) {
                throw mesg.getError("err.syntaxrules.nopattern");
            }
            try {
                ptd = PatternMatch.compilePattern(l0, mpp, st, reserve);
            }
            catch (PatternEllipsisException e) {
                throw mesg.getError("err.wrongellipsis");
            }
        } else {
            throw mesg.getError("err.syntaxrules.malform");
        }
        pat.add(ptd);
        Datum tpl = PatternMatch.compileTemplate(lst.get(1), mpt);
        try {
            PatternMatch.validateLevel(ptd, tpl, st);
        }
        catch (PatternDepthException e) {
            throw mesg.getError("err.wronglevel", e.getMessage());
        }
        tmp.add(lst.get(1));
        stl.add(st);
    }

    private static UserSyntax processSyntaxRules(Symbol name, Datum body, Environment env, boolean definedLetSyntax, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        Set<Symbol> reserve = SyntaxUtils.consToSymbolSet(lst.get(0), mesg);
        ArrayList<Datum> pat = new ArrayList<Datum>();
        ArrayList<Datum> tmp = new ArrayList<Datum>();
        ArrayList<Set<Symbol>> stl = new ArrayList<Set<Symbol>>();
        int i = 1;
        while (i < lst.size()) {
            SyntaxUtils.processRule(name, lst.get(i), pat, tmp, stl, reserve, mesg);
            ++i;
        }
        return new UserSyntax(name.getName(), pat, tmp, stl, reserve, env, definedLetSyntax);
    }

    static UserSyntax processRuleDesc(Symbol name, Datum body, Environment env, boolean definedLetSyntax, LispMessage mesg) {
        if (!(body instanceof Cons)) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        Cons b1 = (Cons)body;
        if (SYNTAX_RULES.equals(b1.getCar())) {
            return SyntaxUtils.processSyntaxRules(name, b1.getCdr(), env, definedLetSyntax, mesg);
        }
        throw mesg.getError("err.syntaxrules.malform");
    }

    static Set<Symbol> consToSymbolSet(Datum d, LispMessage mesg) {
        HashSet<Symbol> res = new HashSet<Symbol>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (dd instanceof Cons) {
                Cons cd = (Cons)dd;
                if (!(cd.getCar() instanceof Symbol)) {
                    throw mesg.getError("err.list.symbol");
                }
                res.add((Symbol)cd.getCar());
                dd = ((Cons)dd).getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return res;
    }

    static boolean equalsReserved(Symbol rword, Datum d) {
        if (d instanceof SymbolScope) {
            return ((SymbolScope)d).getSymbol().equals(rword);
        }
        return rword.equals(d);
    }
}

