/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SynLetSyntaxBase;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.UserSyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynLetrecSyntax
extends SynLetSyntaxBase {
    @Override
    String getName() {
        return "letrec-syntax";
    }

    @Override
    LispException getError(LispMessage mesg) {
        return mesg.getError("err.letrecsyntax.malform");
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        Environment nenv;
        Cons bnam;
        ArrayList<Datum> lvars;
        Datum bcdr;
        CompiledCode.Builder nbuild;
        if (body instanceof Cons) {
            nbuild = new CompiledCode.Builder();
            Datum bcar = ((Cons)body).getCar();
            bcdr = ((Cons)body).getCdr();
            lvars = new ArrayList<Datum>();
            ArrayList<Datum> lvals = new ArrayList<Datum>();
            bnam = new Cons();
            nenv = new Environment(env);
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        List<Datum> l2 = LispUtils.consToList(((Cons)d).getCar(), mesg);
                        if (l2.size() != 2) {
                            throw this.getError(mesg);
                        }
                        lvars.add(l2.get(0));
                        lvals.add(l2.get(1));
                        d = ((Cons)d).getCdr();
                        continue;
                    }
                    throw this.getError(mesg);
                }
            } else {
                throw this.getError(mesg);
            }
            int i = 0;
            while (i < lvars.size()) {
                if (!(lvars.get(i) instanceof Symbol)) {
                    throw mesg.getError("err.letrecsyntax.name");
                }
                Symbol name = (Symbol)lvars.get(i);
                UserSyntax usyn = SyntaxUtils.processRuleDesc(name, (Datum)lvals.get(i), nenv, true, mesg);
                nenv.bindDatum(name, usyn);
                nbuild.addPush(usyn);
                nbuild.addBind(name);
                ++i;
            }
        } else {
            throw this.getError(mesg);
        }
        bnam.setCdr(LispUtils.listToCons(lvars));
        symlist.add(callsym);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, bnam, istail, mesg, symlist);
        symlist.remove(0);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }
}

