/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Promise;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.subr.MakeCons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynConsStream
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        if (lst.size() != 2) {
            throw mesg.getError("err.argument");
        }
        comp.compile(lst.get(1), env, nbuild, callsym, false, symlist);
        nbuild.addReturnOp();
        Promise prms = new Promise(nbuild.getCodeRef());
        build.addPush(new MakeCons());
        build.addBeginList();
        comp.compile(lst.get(0), env, build, callsym, false, symlist);
        build.addAppendList();
        build.addNewPromise(prms);
        build.addAppendList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        ArrayList<Datum> res = new ArrayList<Datum>();
        if (lst.size() != 2) {
            throw mesg.getError("err.argument");
        }
        res.add(comp.replaceLocalVals(lst.get(0), env, ienv, false));
        res.add(comp.replaceLocalVals(lst.get(1), env, ienv, false));
        return LispUtils.listToCons(res);
    }

    public String toString() {
        return "Syntax:cons-stream";
    }
}

