/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternDepthException;
import net.morilib.lisp.PatternDepthIndex;
import net.morilib.lisp.PatternDepthMap;
import net.morilib.lisp.PatternEllipsisException;
import net.morilib.lisp.PatternIntEllipsis;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.UserSyntax;
import net.morilib.lisp.util.NullSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternMatch {
    private static final Datum ELLIPSIS = Symbol.getSymbol("...");
    private static final Datum UNDERBAR = Symbol.getSymbol("_");
    private static final int PATTERN = 0;
    private static final int TEMPLATE = 1;

    PatternMatch() {
    }

    private static Datum compilePattern1(Datum src, PatternDepthMap mp, int typ, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        Datum res;
        block29: {
            Datum d = src;
            res = null;
            Cons rp = null;
            while (d instanceof Cons) {
                Cons c2;
                Cons c = (Cons)d;
                Cons n = new Cons();
                if (ELLIPSIS.equals(c.getCar())) {
                    throw new PatternEllipsisException();
                }
                Datum car = PatternMatch.compilePattern1(c.getCar(), mp, typ, st, reserve);
                if (c.getCdr() instanceof Cons && ELLIPSIS.equals((c2 = (Cons)c.getCdr()).getCar())) {
                    PatternIntEllipsis n2;
                    if (c.getCar() instanceof Symbol && reserve.contains((Symbol)c.getCar())) {
                        throw new PatternEllipsisException();
                    }
                    if (typ == 0) {
                        if (c2.getCdr() instanceof Cons) {
                            throw new LispException("bad ellipsis");
                        }
                        if (c2.getCdr() instanceof Symbol) {
                            st.add((Symbol)c2.getCdr());
                        }
                        n2 = new PatternIntEllipsis(car, c2.getCdr());
                    } else if (typ == 1) {
                        Datum cdr2 = PatternMatch.compilePattern1(c2.getCdr(), mp, typ, st, reserve);
                        n2 = new PatternIntEllipsis(car, cdr2);
                    } else {
                        throw new RuntimeException();
                    }
                    if (rp == null) {
                        res = n2;
                    } else {
                        rp.setCdr(n2);
                    }
                    break block29;
                }
                n.setCar(car);
                if (rp == null) {
                    rp = n;
                    res = rp;
                } else {
                    rp.setCdr(n);
                    rp = n;
                }
                d = c.getCdr();
            }
            if (d instanceof LispVector) {
                LispVector v = (LispVector)d;
                ArrayList<Datum> rv = new ArrayList<Datum>();
                int i = 0;
                while (i < v.size()) {
                    Datum v1 = PatternMatch.compilePattern1(v.get(i), mp, typ, st, reserve);
                    if (i < v.size() - 1 && ELLIPSIS.equals(v.get(i + 1))) {
                        if (v.get(i) instanceof Symbol && reserve.contains((Symbol)v.get(i))) {
                            throw new PatternEllipsisException(((Symbol)v.get(i)).getName());
                        }
                        if (typ == 0) {
                            if (i + 1 != v.size() - 1) {
                                throw new LispException("bad ellipsis");
                            }
                            if (v.get(i + 1) instanceof Symbol) {
                                st.add((Symbol)v.get(i + 1));
                            }
                            rv.add(new PatternIntEllipsis(v1, Nil.NIL, true));
                        } else if (typ == 1) {
                            rv.add(new PatternIntEllipsis(v1, Nil.NIL, true));
                        } else {
                            throw new RuntimeException();
                        }
                        ++i;
                    } else {
                        rv.add(v1);
                    }
                    ++i;
                }
                res = new LispVector(rv);
            } else {
                if (d instanceof Symbol) {
                    st.add((Symbol)d);
                }
                if (rp == null) {
                    res = d;
                } else {
                    rp.setCdr(d);
                }
            }
        }
        return res;
    }

    public static Datum compilePattern(Datum d, PatternDepthMap mp, Set<Symbol> st, Set<Symbol> reserve) throws PatternEllipsisException {
        return PatternMatch.compilePattern1(d, mp, 0, st, reserve);
    }

    public static Datum compileTemplate(Datum d, PatternDepthMap mp) {
        Set<Symbol> sz = NullSet.getInstance();
        Set<Symbol> em = Collections.emptySet();
        try {
            return PatternMatch.compilePattern1(d, mp, 1, sz, em);
        }
        catch (PatternEllipsisException e) {
            throw new RuntimeException("Internal error");
        }
    }

    private static void searchLevel0(Datum in, int lev, Map<Symbol, Integer> res, Set<Symbol> st) {
        Datum sp = in;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.searchLevel0(spc.getCar(), lev, res, st);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.searchLevel0(v.get(i), lev, res, st);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.searchLevel0(si.getEllipsisList(), lev + 1, res, st);
            sp = si.getCdr();
        }
        if (sp instanceof Symbol && st.contains(sp)) {
            Symbol sy = (Symbol)sp;
            res.put(sy, lev);
            return;
        }
    }

    public static void validateLevel(Datum pat, Datum tpl, Set<Symbol> st) throws PatternDepthException {
        HashMap<Symbol, Integer> p0 = new HashMap<Symbol, Integer>();
        HashMap<Symbol, Integer> t0 = new HashMap<Symbol, Integer>();
        PatternMatch.searchLevel0(pat, 0, p0, st);
        PatternMatch.searchLevel0(tpl, 0, t0, st);
        for (Map.Entry d : p0.entrySet()) {
            int ddepth;
            if (!t0.containsKey(d.getKey()) || (ddepth = ((Integer)t0.get(d.getKey())).intValue()) == (Integer)d.getValue()) continue;
            throw new PatternDepthException(((Symbol)d.getKey()).getName());
        }
    }

    private static void collectParam1(Datum src, Set<Symbol> col, Set<Symbol> reserved) {
        Datum sp = src;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.collectParam1(spc.getCar(), col, reserved);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.collectParam1(v.get(i), col, reserved);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.collectParam1(si.getEllipsisList(), col, reserved);
            sp = si.getCdr();
        }
        if (sp instanceof Symbol && !reserved.contains(sp)) {
            col.add((Symbol)sp);
            return;
        }
    }

    private static Set<Symbol> collectParam1(Datum src, Set<Symbol> reserved) {
        HashSet<Symbol> col = new HashSet<Symbol>();
        PatternMatch.collectParam1(src, col, reserved);
        return col;
    }

    private static boolean match(Datum src, Datum dest, PatternDepthMap mp, PatternDepthIndex index, Set<Symbol> reserved) {
        Datum sp = src;
        Datum dp = dest;
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            if (dp instanceof Cons) {
                Cons dpc = (Cons)dp;
                boolean bl = PatternMatch.match(spc.getCar(), dpc.getCar(), mp, index, reserved);
                if (bl) {
                    sp = spc.getCdr();
                    dp = dpc.getCdr();
                    continue;
                }
                return false;
            }
            return false;
        }
        if (sp instanceof LispVector) {
            LispVector vs = (LispVector)sp;
            if (!(dp instanceof LispVector)) {
                return false;
            }
            LispVector vd = (LispVector)dp;
            int i = 0;
            while (i < vs.size()) {
                Datum dd = vs.get(i);
                if (dd instanceof PatternIntEllipsis) {
                    PatternIntEllipsis si = (PatternIntEllipsis)dd;
                    if (si.isUseVector()) {
                        PatternDepthIndex nind = index.addDepthNew();
                        int j = i;
                        while (j < vd.size()) {
                            boolean mtr = PatternMatch.match(si.getEllipsisList(), vd.get(j), mp, nind, reserved);
                            if (!mtr) {
                                return false;
                            }
                            nind = nind.incNew();
                            ++j;
                        }
                        Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
                        int rep = nind.pop();
                        mp.setRepetaion(col, nind, rep);
                        return true;
                    }
                    boolean bl = PatternMatch.match(vs.get(i), vd.get(i), mp, index, reserved);
                    if (!bl) {
                        return false;
                    }
                } else {
                    if (i >= vd.size()) {
                        return false;
                    }
                    boolean bl = PatternMatch.match(vs.get(i), vd.get(i), mp, index, reserved);
                    if (!bl) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        if (sp instanceof PatternIntEllipsis) {
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            Datum pt = dp;
            PatternDepthIndex nind = index.addDepthNew();
            while (pt instanceof Cons) {
                Cons ptc = (Cons)pt;
                boolean mtr = PatternMatch.match(si.getEllipsisList(), ptc.getCar(), mp, nind, reserved);
                if (mtr) {
                    pt = ptc.getCdr();
                    nind = nind.incNew();
                    continue;
                }
                return false;
            }
            Set<Symbol> col = PatternMatch.collectParam1(si.getEllipsisList(), reserved);
            int rep = nind.pop();
            mp.setRepetaion(col, nind, rep);
            return PatternMatch.match(si.getCdr(), pt, mp, index, reserved);
        }
        if (sp instanceof Symbol && !reserved.contains(sp)) {
            mp.put((Symbol)sp, index, dp);
            return true;
        }
        if (sp.equals(UNDERBAR)) {
            return true;
        }
        return sp.isEqv(dp);
    }

    public static boolean match(Datum src, Datum dest, PatternDepthMap mp, Set<Symbol> reserved) {
        return PatternMatch.match(src, dest, mp, new PatternDepthIndex(), reserved);
    }

    private static void collectParam2(Datum src, Set<Symbol> col, PatternDepthMap mp) {
        Datum sp = src;
        while (true) {
            if (sp instanceof Cons) {
                Cons spc = (Cons)sp;
                PatternMatch.collectParam2(spc.getCar(), col, mp);
                sp = spc.getCdr();
                continue;
            }
            if (sp instanceof LispVector) {
                LispVector v = (LispVector)sp;
                int i = 0;
                while (i < v.size()) {
                    PatternMatch.collectParam2(v.get(i), col, mp);
                    ++i;
                }
                return;
            }
            if (!(sp instanceof PatternIntEllipsis)) break;
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            PatternMatch.collectParam2(si.getEllipsisList(), col, mp);
            sp = si.getCdr();
        }
        if (sp instanceof Symbol) {
            if (mp.contains((Symbol)sp)) {
                col.add((Symbol)sp);
            }
            return;
        }
    }

    private static Set<Symbol> collectParam2(Datum src, PatternDepthMap mp) {
        HashSet<Symbol> col = new HashSet<Symbol>();
        PatternMatch.collectParam2(src, col, mp);
        return col;
    }

    private static Datum expand1(Datum templ, PatternDepthMap args, PatternDepthIndex index, UserSyntax usyn, Map<Symbol, Symbol> box) throws PatternDepthException {
        Datum sp = templ;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons n = new Cons();
            Datum car = PatternMatch.expand1(spc.getCar(), args, index, usyn, box);
            if (car == null) {
                return null;
            }
            n.setCar(car);
            bld1.append(n);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector ve = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int j = 0;
            while (j < ve.size()) {
                Datum dd = ve.get(j);
                if (dd instanceof PatternIntEllipsis) {
                    PatternIntEllipsis si = (PatternIntEllipsis)dd;
                    Set<Symbol> params = PatternMatch.collectParam2(si.getEllipsisList(), args);
                    int rep = args.getRepetaion(params, index);
                    index.addDepth();
                    int i = 0;
                    while (i < rep) {
                        Datum rpt = PatternMatch.expand1(si.getEllipsisList(), args, index, usyn, box);
                        if (rpt == null) {
                            int v = index.pop();
                            if (v > 0) break;
                            return null;
                        }
                        vr.add(rpt);
                        ++i;
                        index.inc();
                    }
                    index.pop();
                } else {
                    Datum d3 = PatternMatch.expand1(ve.get(j), args, index, usyn, box);
                    if (d3 == null) {
                        return null;
                    }
                    vr.add(d3);
                }
                ++j;
            }
            return new LispVector(vr);
        }
        if (sp instanceof PatternIntEllipsis) {
            PatternIntEllipsis si = (PatternIntEllipsis)sp;
            ConsListBuilder bld2 = new ConsListBuilder();
            Set<Symbol> params = PatternMatch.collectParam2(si.getEllipsisList(), args);
            int rep = args.getRepetaion(params, index);
            index.addDepth();
            int i = 0;
            while (i < rep) {
                Cons n = new Cons();
                Datum rpt = PatternMatch.expand1(si.getEllipsisList(), args, index, usyn, box);
                if (rpt == null) {
                    int v = index.pop();
                    if (v > 0) break;
                    return null;
                }
                n.setCar(rpt);
                bld2.append(n);
                ++i;
                index.inc();
            }
            index.pop();
            Datum cdr = PatternMatch.expand1(si.getCdr(), args, index, usyn, box);
            if (cdr == null) {
                return null;
            }
            return bld1.get(bld2.get(cdr));
        }
        if (sp instanceof Symbol) {
            Symbol sy1 = (Symbol)sp;
            if (args.contains(sy1)) {
                Datum dt = args.get(sy1, index);
                dt = PatternMatch.markReplace(box, dt, true);
                return bld1.get(dt);
            }
            if (sy1.isGenerated()) {
                return bld1.get(sy1);
            }
            return bld1.get(sy1);
        }
        return bld1.get(sp);
    }

    public static Datum expand(Datum templ, PatternDepthMap args, UserSyntax usyn, Map<Symbol, Symbol> box) throws PatternDepthException {
        Datum res = PatternMatch.expand1(templ, args, new PatternDepthIndex(), usyn, box);
        if (res == null) {
            throw new LispException("syntax expansion has failed");
        }
        return res;
    }

    public static Datum appendScope(Datum src, PatternDepthMap args, UserSyntax usyn) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.appendScope(spc.getCar(), args, usyn));
            bld1.append(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.appendScope(v.get(i), args, usyn));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof Symbol) {
            Symbol sy1 = (Symbol)sp;
            if (sy1.isReplaced()) {
                return bld1.get(sy1);
            }
            if (sy1.isGenerated()) {
                return bld1.get(sy1);
            }
            return bld1.get(new SymbolScope(sy1, usyn));
        }
        return bld1.get(sp);
    }

    public static Datum removeScope(Datum src) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.removeScope(spc.getCar()));
            bld1.append(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.removeScope(v.get(i)));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof SymbolScope) {
            return bld1.get(((SymbolScope)sp).getSymbol());
        }
        return bld1.get(sp);
    }

    public static Datum markReplace(Map<Symbol, Symbol> box, Datum src, boolean mark) {
        Datum sp = src;
        ConsListBuilder bld1 = new ConsListBuilder();
        while (sp instanceof Cons) {
            Cons spc = (Cons)sp;
            Cons app = new Cons();
            app.setCar(PatternMatch.markReplace(box, spc.getCar(), mark));
            bld1.append(app);
            sp = spc.getCdr();
        }
        if (sp instanceof LispVector) {
            LispVector v = (LispVector)sp;
            ArrayList<Datum> vr = new ArrayList<Datum>();
            int i = 0;
            while (i < v.size()) {
                vr.add(PatternMatch.markReplace(box, v.get(i), mark));
                ++i;
            }
            return new LispVector(vr);
        }
        if (sp instanceof Symbol) {
            Symbol mk = Symbol.newAndMark(box, (Symbol)sp, mark);
            return bld1.get(mk);
        }
        return bld1.get(sp);
    }
}

