/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispArithmeticException;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.util.Utils;

public final class LispRational
extends LispExactReal {
    private BigInteger numer;
    private BigInteger denom;

    private LispRational(BigInteger num, BigInteger den) {
        this.numer = num;
        this.denom = den;
    }

    public static final LispExactReal newRational(BigInteger num, BigInteger den) {
        BigInteger n = num;
        BigInteger d = den;
        int nsig = num.signum();
        int dsig = den.signum();
        if (dsig == 0) {
            throw new LispArithmeticException("denominator is zero");
        }
        if (nsig == 0) {
            return LispInteger.ZERO;
        }
        if (dsig < 0) {
            n = n.negate();
            d = d.negate();
        }
        BigInteger gcd = n.gcd(d);
        n = n.divide(gcd);
        if ((d = d.divide(gcd)).equals(BigInteger.ONE)) {
            return LispInteger.valueOf(n);
        }
        return new LispRational(n, d);
    }

    public static final LispExactReal newRational(int num, int den) {
        int n1 = num;
        int d1 = den;
        if (d1 == 0) {
            throw new LispArithmeticException("denominator is zero");
        }
        if (n1 == 0) {
            return LispInteger.ZERO;
        }
        if (d1 < 0) {
            n1 = -n1;
            d1 = -d1;
        }
        int gcd = Utils.gcd(n1, d1);
        n1 /= gcd;
        if ((d1 /= gcd) == 1) {
            return LispInteger.valueOf(n1);
        }
        return new LispRational(BigInteger.valueOf(n1), BigInteger.valueOf(d1));
    }

    public BigInteger getNumerator() {
        return this.numer;
    }

    public BigInteger getDenominator() {
        return this.denom;
    }

    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.getRealDouble() + c.getRealDouble(), c.getImagDouble());
        }
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.denom).add(n.numer.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = this.numer.add(n.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            double d2 = d1 + ((LispDouble)x).doubleValue();
            return new LispDouble(d2);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).getRealDouble();
            double xi = ((LispComplex)x).getImagDouble();
            double n = this.getRealDouble();
            if (xr == 0.0) {
                return LispComplex.newComplex(0.0, -n / xi);
            }
            return LispComplex.newComplex(n * xr / (xr * xr + xi * xi), -(n * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.numer);
            BigInteger nn = this.numer.multiply(n.denom);
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = n.multiply(this.denom);
            BigInteger nn = this.numer;
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            double d2 = d1 / ((LispDouble)x).doubleValue();
            return new LispDouble(d2);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            return false;
        }
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        if (x instanceof LispInteger) {
            return false;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 == ((LispDouble)x).doubleValue();
        }
        throw new IllegalArgumentException(x.toString());
    }

    public boolean isLessThan(LispReal x) {
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational n = (LispRational)x;
            BigInteger n1 = this.numer.multiply(n.denom);
            return n1.compareTo(n2 = n.numer.multiply(this.denom)) < 0;
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger n2 = n.multiply(this.denom);
            return this.numer.compareTo(n2) < 0;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 < x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational n = (LispRational)x;
            BigInteger n1 = this.numer.multiply(n.denom);
            return n1.compareTo(n2 = n.numer.multiply(this.denom)) > 0;
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger n2 = n.multiply(this.denom);
            return this.numer.compareTo(n2) > 0;
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            return d1 > x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (c.getRealDouble() == 0.0) {
                return LispComplex.newComplex(0.0, this.getRealDouble() * c.getImagDouble());
            }
            return LispComplex.newComplex(this.getRealDouble() * c.getRealDouble(), this.getRealDouble() * c.getImagDouble());
        }
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.numer);
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = n.multiply(this.numer);
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            double d2 = d1 * ((LispDouble)x).doubleValue();
            return new LispDouble(d2);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.getRealDouble() - c.getRealDouble(), -c.getImagDouble());
        }
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            BigInteger nd = this.denom.multiply(n.denom);
            BigInteger nn = this.numer.multiply(n.denom).subtract(n.numer.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispInteger) {
            BigInteger n = x.getBigInteger();
            BigInteger nd = this.denom;
            BigInteger nn = this.numer.subtract(n.multiply(this.denom));
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            double d1 = this.numer.doubleValue() / this.denom.doubleValue();
            double d2 = d1 - ((LispDouble)x).doubleValue();
            return new LispDouble(d2);
        }
        throw new IllegalArgumentException(x.toString());
    }

    public LispNumber uminus() {
        return new LispRational(this.numer.negate(), this.denom);
    }

    public int signum() {
        return this.numer.signum();
    }

    public LispNumber toInexact() {
        return new LispDouble(this.numer.doubleValue() / this.denom.doubleValue());
    }

    public String getResult() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }

    public String print() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }

    public boolean equals(Object x) {
        if (x instanceof LispRational) {
            LispRational n = (LispRational)x;
            return this.numer.equals(n.numer) && this.denom.equals(n.denom);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.numer.hashCode();
        l = 37 * l + this.denom.hashCode();
        return l;
    }

    public String toString() {
        return String.valueOf(this.numer.toString()) + "/" + this.denom.toString();
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isRational() {
        return true;
    }

    public boolean isReal() {
        return true;
    }

    public boolean isExact() {
        return true;
    }

    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(String.valueOf(this.numer.toString(radix)) + "/" + this.denom.toString(radix));
    }

    public boolean isOne() {
        return this.numer.equals(this.denom);
    }

    public BigInteger getBigInteger() {
        return this.numer.divide(this.denom);
    }

    public int getInt() {
        return this.getBigInteger().intValue();
    }

    public long getLong() {
        return this.getBigInteger().longValue();
    }

    public BigDecimal getBigDecimal() {
        BigDecimal n = new BigDecimal(this.numer);
        BigDecimal d = new BigDecimal(this.denom);
        return n.divide(d);
    }

    public double getRealDouble() {
        return this.numer.doubleValue() / this.denom.doubleValue();
    }
}

