/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigInteger;
import net.morilib.lisp.LispBigInt;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispSmallInt;

public abstract class LispInteger
extends LispExactReal {
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final LispInteger ZERO = LispInteger.valueOf(0);
    public static final LispInteger ONE = LispInteger.valueOf(1);

    public static LispInteger valueOf(BigInteger val) {
        if (val.compareTo(INT_MAX) > 0 || val.compareTo(INT_MIN) < 0) {
            return new LispBigInt(val);
        }
        return new LispSmallInt(val.intValue());
    }

    public static LispInteger valueOf(int val) {
        return new LispSmallInt(val);
    }

    public static LispInteger valueOf(long val) {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            return new LispBigInt(BigInteger.valueOf(val));
        }
        return new LispSmallInt((int)val);
    }

    public BigInteger getNumerator() {
        return this.getBigInteger();
    }

    public BigInteger getDenominator() {
        return BigInteger.ONE;
    }

    public boolean isInteger() {
        return true;
    }

    public boolean isRational() {
        return true;
    }

    public boolean isReal() {
        return true;
    }

    public boolean isExact() {
        return true;
    }
}

