/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;

public final class LispCharacter
extends Atom {
    public static final LispCharacter NEWLINE = new LispCharacter('\n');
    public static final LispCharacter SPACE = new LispCharacter(' ');
    private char character;

    public LispCharacter(char ch) {
        this.character = ch;
    }

    private static String getName(char ch) {
        if (ch == '\n') {
            return "newline";
        }
        if (ch == ' ') {
            return "space";
        }
        return Character.toString(ch);
    }

    public static LispCharacter getByName(String name) {
        if ("newline".equals(name)) {
            return NEWLINE;
        }
        if ("space".equals(name)) {
            return SPACE;
        }
        return null;
    }

    public char getCharacter() {
        return this.character;
    }

    public String getResult() {
        return "#\\" + LispCharacter.getName(this.character);
    }

    public String print() {
        return Character.toString(this.character);
    }

    public LispString toLispString() {
        return new LispString("#\\" + LispCharacter.getName(this.character));
    }

    public boolean equals(Object d) {
        if (d instanceof LispCharacter) {
            return this.character == ((LispCharacter)d).character;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.character;
        return l;
    }

    public String toString() {
        return Character.toString(this.character);
    }

    public boolean isTypeCharacter() {
        return true;
    }
}

