﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SCFiler3.ViewModel {
	/// <summary>
	/// ViewModel全体を管理するクラス
	/// </summary>
	class ViewModelManager {
		private static ViewModelManager _instance = new ViewModelManager();
		public static ViewModelManager Instance {
			get { return _instance; }
		}

		private List<ViewModelBase> _viewModels = new List<ViewModelBase>();

		/// <summary>
		/// ViewModelを追加する
		/// </summary>
		/// <param name="viewModel"></param>
		public void AddViewModel(ViewModelBase viewModel) {
			this._viewModels.Add(viewModel);
			MessageViewModel _message = viewModel as MessageViewModel;
			if (_message != null) {
				this._allMessageViewModel.Add(_message);
			}

		}

		/// <summary>
		/// ViewModelを削除する
		/// </summary>
		/// <param name="viewModel"></param>
		public void RemoveViewModel(ViewModelBase viewModel) {
			this._viewModels.Remove(viewModel);
			MessageViewModel _message = viewModel as MessageViewModel;
			if (_message != null) {
				this._allMessageViewModel.Remove(_message);
			}
		}

		private List<MessageViewModel> _allMessageViewModel = new List<MessageViewModel>();

		/// <summary>
		/// メッセージを受け取る全てのViewModelを返す
		/// </summary>
		public List<MessageViewModel> AllMessageViewModel {
			get { return this._allMessageViewModel; }
		}
	}
}
