﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SCFiler3.ViewModel {
	/// <summary>
	/// SCFiler3のメイン画面を構成するViewModelのBaseクラス
	/// ※メイン画面に表示しないViewModelはこのクラスから派生しない可能性がある（現実装段階で未定）
	/// </summary>
	class ViewModelBase : IDisposable {
		public ViewModelBase() {
			ViewModelManager.Instance.AddViewModel(this);
		}

		#region IDisposable メンバ

		public void Dispose() {
			ViewModelManager.Instance.RemoveViewModel(this);
		}

		#endregion
	}
}
