﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SCFiler3.ViewModel {
	/// <summary>
	/// メッセージ追加の内容
	/// </summary>
	public class MessageAddedEventArgs : EventArgs {
		public string Message { get; set; }
		public MessageAddedEventArgs(string message) {
			Message = message;
		}
	}

	/// <summary>
	/// ユーザーへのメッセージを表示するビュー
	/// </summary>
	class MessageViewModel : ViewModelBase {
		/// <summary>
		/// メッセージ追加イベント
		/// </summary>
		public EventHandler<MessageAddedEventArgs> MessageAdd;

		/// <summary>
		/// メッセージ追加を通知する
		/// </summary>
		/// <param name="text"></param>
		public void AddMessage(string text) {
			var _hander = MessageAdd;
			if (MessageAdd != null) {
				_hander(null, new MessageAddedEventArgs(text));
			}
		}
	}


}
