﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SCFiler3.Model;
using System.Diagnostics;
using System.Collections.ObjectModel;

namespace SCFiler3.ViewModel {
	/// <summary>
	/// FileViewModelのフォーカスが移動した時のイベント
	/// </summary>
	class FileItemFocusChangedEventArgs : EventArgs {
		private IFilerItem _item;
		public void FocusChangedEventArgs(IFilerItem item) {
			_item = item;
		}

		public IFilerItem Item {
			get { return _item; }
		}
	}

	/// <summary>
	/// フォルダ構造を表示するViewModel　(SCFiler2のメイン画面のViewModel)
	/// </summary>
	class FileViewModel {
		/// <summary>
		/// カレントフォルダのアイテム全部
		/// </summary>
		private ObservableCollection<IFilerItem> _items = new ObservableCollection<IFilerItem>();

		/// <summary>
		/// このViewModelが表示中のカレントフォルダ
		/// ListViewのCurrentItemと紛らわしいので、ソースコード上はworking～という名称を使う
		/// </summary>
		private IItemContainable _workingFolder;

		public FileViewModel() {
			//とりあえず最初はCドライブを表示しておく
			ChangeWorkingFolder(new DriveItem(@"C:\"));
		}

		/// <summary>
		/// カレントフォルダの全アイテム
		/// </summary>
		public ObservableCollection<IFilerItem> Items {
			get { return _items; }
		}

		public string WorkingFolder {
			get { return _workingFolder.FullName; }
		}

		/// <summary>
		/// カレントフォルダを変更する
		/// </summary>
		/// <param name="newFolder">移動先のフォルダ</param>
		public void ChangeWorkingFolder(IItemContainable newFolder) {
			_items.Clear();
			try {
				foreach (IItemContainable folder in newFolder.ChildFolders) {
					_items.Add(folder);
				}
				foreach (FileItem file in newFolder.ChildFiles) {
					_items.Add(file);
				}
				_workingFolder = newFolder;
			} catch (Exception e) {
				//TODO
				Debug.WriteLine("<FilewViewModel>" + e.Message);
			}
		}

		/// <summary>
		/// カレントフォルダを親へ移動する
		/// </summary>
		public void ChangeWorkingFolderToParent() {
			if (_workingFolder.Type == ItemType.Root) {
				//TODO
			} else {
				ChangeWorkingFolder(_workingFolder.ParentFolder);
			}

		}

		/// <summary>
		/// 現在フォーカスがあるアイテムを実行する
		/// </summary>
		/// <param name="item">実行するアイテム</param>
		public void ExecuteCurrentItem(IFilerItem item) {
			switch (item.Type) {
				case ItemType.Drive:
					var drive = item as DriveItem;
					ChangeWorkingFolder(drive);
					break;
				case ItemType.File:
					var file = item as FileItem;
					System.Diagnostics.Process.Start(file.FullName);
					break;
				case ItemType.Folder:
					var folder = item as FolderItem;
					this.ChangeWorkingFolder(folder);
					break;
			}
		}
	}
}
