﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections.ObjectModel;
using SCFiler3.ViewModel;
using SCFiler3.Command;
using SCFiler3.Model;

namespace SCFiler3.View {
	/// <summary>
	/// FileViewItem.xaml の相互作用ロジック
	/// SCFiler3のメインとなる、ファイル一覧を表示するビュー
	/// </summary>
	public partial class FileViewItem : UserControl {

		/// <summary>
		/// このViewが表示するViewModel
		/// </summary>
		private FileViewModel _viewModel = new FileViewModel();

		/// <summary>
		/// コンストラクタ
		/// </summary>
		public FileViewItem() {
			InitializeComponent();

			//ViewModelを表示アイテムとして設定
			this.FileList.ItemsSource = _viewModel.Items;
			this.FileList.IsSynchronizedWithCurrentItem = true;

			//キーバインド設定
			this.InputBindings.Add(new InputBinding(SCFiler3Commands.ExecuteCurrentItem, new KeyGesture(Key.Enter)));
			this.InputBindings.Add(new InputBinding(SCFiler3Commands.MoveCurrentFolderToParent, new KeyGesture(Key.Back)));
		}

		private void CommandBinding_ExecuteCurrentItemExecuted(object sender, ExecutedRoutedEventArgs e) {
			var item = this.FileList.Items.CurrentItem as IFilerItem;
			if (item != null) {
				_viewModel.ExecuteCurrentItem(item);
			}
		}

		private void CommandBinding_MoveCurrentFolderToParentExecuted(object sender, ExecutedRoutedEventArgs e) {
			_viewModel.ChangeWorkingFolderToParent();
		}
	}
}
