﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SCFiler3.Model {
	public enum ItemType {
		File,
		Folder,
		Drive,
		Root,
	}

	/// <summary>
	/// SCFiler3で様々な箇所に表示するリスト用のアイテムを表す
	/// </summary>
	interface IFilerItem {
		ItemType Type { get; }

		/// <summary>
		/// パスも含んだ名称
		/// </summary>
		string FullName { get; }

		/// <summary>
		/// パスを含まない名称（拡張子含む）
		/// </summary>
		string Name { get; }

		/// <summary>
		/// 拡張子
		/// </summary>
		string Extension { get; }

		/// <summary>
		/// 拡張子を除いた名称。
		/// ただし、表示にのみ使用されることを想定しているので、加工される可能性がある
		/// 例：ドライブは "C:\" → "ローカルディスク (C:\)" のようなボリュームラベルを反映したわかりやすい名前になる
		/// </summary>
		string NameWithoutExtension { get; }

		/// <summary>
		/// サイズ（表示用）
		/// そのまま数値としては利用できない
		/// 1024 → 1KB などと加工される可能性があるため
		/// </summary>
		string SizeText { get; }

		/// <summary>
		/// 親フォルダ
		/// </summary>
		IItemContainable ParentFolder { get; }
	}
}
