﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace SCFiler3.Model {
	/// <summary>
	/// フォルダを表すアイテム
	/// </summary>
	class FolderItem : IFilerItem , IItemContainable {
		private DirectoryInfo _info;
		public FolderItem(string fullName)
			: this(new DirectoryInfo(fullName)){
		}

		public FolderItem(DirectoryInfo info) {
			_info = info;
		}

		#region IFilerItem メンバ

		public string FullName {
			get { return this._info.FullName; }
		}

		public string Name {
			get { return this._info.Name; }
		}

		public string Extension {
			get { return this._info.Extension; }
		}

		public string NameWithoutExtension {
			get { return this._info.Name; }
		}

		public string SizeText {
			get { return ""; }
		}

		public ItemType Type {
			get { return ItemType.Folder; }
		}

		public IItemContainable ParentFolder {
			get {
				if (_info.Parent.Name == _info.Root.Name) {
					return new DriveItem(new DriveInfo(_info.Root.FullName));
				} else {
					return new FolderItem(_info.Parent);
				}
			}
		}

		#endregion

		public IList<IItemContainable> ChildFolders {
			get {
				var child = new List<IItemContainable>();
				foreach (DirectoryInfo info in _info.GetDirectories()) {
					child.Add(new FolderItem(info));
				}
				return child;
			}
		}

		public IList<FileItem> ChildFiles {
			get {
				var child = new List<FileItem>();
				foreach (FileInfo info in _info.GetFiles()) {
					child.Add(new FileItem(info));
				}
				return child;
			}
		}
	}
}
