﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace SCFiler3.Model {
	/// <summary>
	/// 全てのアイテムのルート
	/// エクスプローラでいえばマイコンピュータを開いた位置に相当する。ドライブ一覧を所持するアイテム
	/// ファイル階層の実装の容易さのため用意しているが、FileViewModelでカレント位置を示すくらいしか想定していないので
	/// 使用される予定がないメンバはアクセスされると例外を発生する
	/// </summary>
	class FilerItemsRoot : IItemContainable {
		static private FilerItemsRoot _instance = new FilerItemsRoot();

		static public FilerItemsRoot Instance {
			get {return _instance;}
		}

		private FilerItemsRoot() {
		}

		#region IItemContainable メンバ

		/// <summary>
		/// ChildFolderという名称だが実際にはドライブ一覧を返す
		/// 名前を変えた方がいいかもしれないが、プログラム全体のほとんどの箇所ではChildFolders/ChildFilesの対比で書けた方がわかりやすいと思うので
		/// とりあえず実装を進めてみて不都合がでるまではこのままでいく
		/// </summary>
		public IList<IItemContainable> ChildFolders {
			get {
				List<IItemContainable> drives = new List<IItemContainable>();
				foreach (DriveInfo drive in System.IO.DriveInfo.GetDrives()) {
					drives.Add(new DriveItem(drive));
				}
				return drives;
			}
		}

		/// <summary>
		/// 必ず空のリストを返す
		/// </summary>
		public IList<FileItem> ChildFiles {
			get {
				List<FileItem> files = new List<FileItem>();
				return files;
			}
		}

		#endregion

		#region IFilerItem メンバ

		public ItemType Type {
			get { return ItemType.Root; }
		}

		public string FullName {
			get { throw new NotImplementedException(); }
		}

		public string Name {
			get { throw new NotImplementedException(); }
		}

		public string Extension {
			get { throw new NotImplementedException(); }
		}

		public string NameWithoutExtension {
			get { throw new NotImplementedException(); }
		}

		public string SizeText {
			get { throw new NotImplementedException(); }
		}

		public IItemContainable ParentFolder {
			get { throw new NotImplementedException(); }
		}

		#endregion
	}
}
