﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace SCFiler3.Model {
	/// <summary>
	/// ファイルを表すアイテム
	/// </summary>
	class FileItem : IFilerItem {
		private FileInfo info;
		public FileItem(FileInfo info) {
			this.info = info;
		}

		#region IFilerItem メンバ

		public string FullName {
			get { return this.info.FullName; }
		}

		public string Name {
			get { return this.info.Name; }
		}

		public string Extension {
			get { return this.info.Extension; }
		}

		public string NameWithoutExtension {
			get {
				if (this.info.Extension.Equals("")) {
					return this.info.Name;
				} else {
					return this.info.Name.Replace(this.info.Extension, "");
				}
			}
		}

		public string SizeText {
			get { return this.info.Length.ToString(); }
		}

		public ItemType Type {
			get { return ItemType.File; }
		}

		public IItemContainable ParentFolder {
			get {
				return new FolderItem(info.Directory);
			}
		}

		#endregion
	}
}
