﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace SCFiler3.Model {
	/// <summary>
	/// ドライブを表すアイテム
	/// </summary>
	class DriveItem : IFilerItem, IItemContainable {
		DriveInfo _info;
		public DriveItem(string FullName) 
			: this(new DriveInfo(FullName)) {
		}

		public DriveItem(DriveInfo info) {
			_info = info;
		}

		#region IFilerItem メンバ

		public ItemType Type {
			get { return ItemType.Drive; }
		}

		public string FullName {
			get { return _info.Name; }
		}

		public string Name {
			get { return _info.Name; }
		}

		public string Extension {
			get { return ""; }
		}

		public string NameWithoutExtension {
			get {
				if (_info.VolumeLabel == "") {
					return "ドライブ (" + _info.Name + ")";
				} else {
					return _info.VolumeLabel + " (" + _info.Name + ")";
				}
			}
		}

		public string SizeText {
			get { return ""; }
		}

		public IItemContainable ParentFolder {
			get {
				return FilerItemsRoot.Instance;
			}
		}

		#endregion

		#region IItemContainable メンバ

		public IList<IItemContainable> ChildFolders {
			get {
				IList<IItemContainable> folders = new List<IItemContainable>();
				foreach (DirectoryInfo folder in _info.RootDirectory.GetDirectories()) {
					folders.Add(new FolderItem(folder));
				}
				return folders;
			}
		}

		public IList<FileItem> ChildFiles {
			get {
				IList<FileItem> files = new List<FileItem>();
				foreach (FileInfo file in _info.RootDirectory.GetFiles()) {
					files.Add(new FileItem(file));
				}
				return files;
			}
		}

		#endregion

	}
}
