﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using SCFiler3.WindowParts;
using SCFiler3.Model;
using SCFiler3.Command;

namespace SCFiler3 {
	/// <summary>
	/// MainWindow.xaml の相互作用ロジック
	/// </summary>
	public partial class MainWindow : Window {
		public MainWindow() {
			InitializeComponent();
			this.InputBindings.Add(new InputBinding(SCFiler3Commands.ExitApplication, new KeyGesture(Key.Escape)));
			Message.PrintLog("SCFiler3を起動しました");
		}

		private void CommandBinding_ExitApplicationExecuted(object sender, ExecutedRoutedEventArgs e) {
			this.Close();
		}

		private void CommandBinding_ExitApplicationCanExecute(object sender, CanExecuteRoutedEventArgs e) {
			e.CanExecute = true;
		}

		private void CommandBinding_ShowAboutBoxExecuted(object sender, ExecutedRoutedEventArgs e) {
			AboutBox about = new AboutBox();
			about.Owner = this;
			about.ShowDialog();
		}
	}
}
