﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

//２重起動防止用（Diagnostics,InteropServices）
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace SCFiler2 {
	static class Program {
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main() {
			//すでにSCFiler2のプロセスがあったらそれを表示。なかったら起動
			if (!ShowPrevProcess()) {
				Application.EnableVisualStyles();
				Application.SetCompatibleTextRenderingDefault(false);
				Application.Run(new MainForm());
			}
		}

		#region ２重起動防止ロジック
		[DllImport("USER32.DLL", CharSet = CharSet.Auto)]
		private static extern int ShowWindow(
			System.IntPtr hWnd,
			int nCmdShow
		);

		[DllImport("USER32.DLL", CharSet = CharSet.Auto)]
		private static extern bool SetForegroundWindow(
			System.IntPtr hWnd
		);

		private const int SW_NORMAL = 1;
		public static bool ShowPrevProcess() {
			Process hThisProcess = Process.GetCurrentProcess();
			Process[] hProcesses = Process.GetProcessesByName(hThisProcess.ProcessName);
			int iThisProcessId = hThisProcess.Id;

			foreach (Process hProcess in hProcesses) {
				if (hProcess.Id != iThisProcessId) {
					//TODO なぜ必要なのわからない。あると逆にうまくいかない？　調べる
					//ShowWindow(hProcess.MainWindowHandle, SW_NORMAL);
					SetForegroundWindow(hProcess.MainWindowHandle);
					return true;
				}
			}

			return false;
		}
		#endregion
	}
}