﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class OpenByExplorer : Action{
		public override string DisplayString {
			get { return "エクスプローラで開く"; }
		}

		public override Action.ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView view = main_form.getLastFocusedFileView();
				Process.Start(view.CurrentPath);
				//履歴ビューに通知
				foreach (HistoryManager manager in main_form.AllHistoryManager) {
					manager.notifyItemExecuted(FilerItem.createItem(view.CurrentPath));
				}
			} else {
				//FileView以外では何もしない
			}
		}
	}
}
