using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace SCFiler2.FileSystem {
	public abstract class FilerItem {
		public enum ItemType {
			File,
			Folder
		}
		abstract public FileSystemInfo Info {get;}
		abstract public ItemType Type { get;}
		abstract public string Path { get; }
		abstract public string NameWithoutExtension { get;}
		/// <summary>
		/// TCY\i1024ȏKBƕ\L铙AȃTCYł͂Ȃj
		/// </summary>
		abstract public string SizeDisplayString { get;}

		/// <summary>
		/// full_namet@C/tH_𔻒fāAFileFolderNX𐶐
		/// </summary>
		/// <param name="full_name">t@CtH_̃tpX</param>
		/// <returns>CX^XBfull_namẽt@C/tH_݂Ȃnull</returns>
		static public FilerItem createItem(string full_name) {
			if (System.IO.Directory.Exists(full_name)) {
				return new Folder(full_name);
			} else if (System.IO.File.Exists(full_name)) {
				return new File(full_name);
			} else {
				return null;
			}
		}

		/// <summary>
		/// t@CRs[
		/// </summary>
		/// <param name="item_list">Rs[t@C̃Xg</param>
		/// <param name="target_folder">Rs[̃tH_</param>
		public static void copy(List<FilerItem> item_list, string target_folder) {
			SCFiler2System.showTempMessage("t@C̃Rs[Jn܂");
			try {
				foreach (FilerItem item in item_list) {
					if (item.Type == ItemType.File) {
						Microsoft.VisualBasic.FileIO.FileSystem.CopyFile(item.Info.FullName, target_folder + "\\" + item.Info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs);
					} else {
						Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory(item.Info.FullName, target_folder + "\\" + item.Info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs);
					}
				}
			} catch (OperationCanceledException) {
				SCFiler2System.showTempMessage("t@C̃Rs[̓LZ܂");
			}
		}

		/// <summary>
		/// source_filesStarget_folderɃRs[
		/// </summary>
		/// <param name="source_files">Rs[t@C/tH_</param>
		/// <param name="target_folder">Rs[</param>
		public static void copy(string[] source_files, string target_folder) {
			SCFiler2System.showTempMessage("t@C̃Rs[Jn܂");
			try {
				foreach (string item in source_files) {
					if (System.IO.Directory.Exists(item)) { //fBNgǂ𒲂ׂ
						System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(item);
						Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory(item, target_folder + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					} else {
						System.IO.FileInfo info = new System.IO.FileInfo(item);
						Microsoft.VisualBasic.FileIO.FileSystem.CopyFile(item, target_folder + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					}
				}
			} catch (OperationCanceledException) {
				SCFiler2System.showTempMessage("t@C̃Rs[̓LZ܂");
			}
		}

		/// <summary>
		/// t@Cړ
		/// </summary>
		/// <param name="item_list">ړt@C̃Xg</param>
		/// <param name="target_folder">ړ̃tH_</param>
		public static void move(List<FilerItem> item_list, string target_folder) {
			SCFiler2System.showTempMessage("t@C̈ړJn܂");
			try {
				foreach (FilerItem item in item_list) {
					if (item.Type == ItemType.File) {
						Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(item.Info.FullName, target_folder + "\\" + item.Info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs);
					} else {
						Microsoft.VisualBasic.FileIO.FileSystem.MoveDirectory(item.Info.FullName, target_folder + "\\" + item.Info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs);
					}
				}
			} catch (OperationCanceledException) {
				SCFiler2System.showTempMessage("t@C̈ړ̓LZ܂");
			}
		}

		/// <summary>
		/// t@CꊇĈړ
		/// </summary>
		/// <param name="source_files">ړ̃t@C̔z</param>
		/// <param name="target_folder">ړ̃tH_</param>
		public static void move(string[] source_files, string target_folder) {
			SCFiler2System.showTempMessage("t@C̈ړJn܂");
			try {
				foreach (string item in source_files) {
					if (System.IO.Directory.Exists(item)) {
						System.IO.DirectoryInfo info = new System.IO.DirectoryInfo(item);
						Microsoft.VisualBasic.FileIO.FileSystem.MoveDirectory(item, target_folder + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					} else {
						System.IO.FileInfo info = new System.IO.FileInfo(item);
						Microsoft.VisualBasic.FileIO.FileSystem.MoveFile(item, target_folder + "\\" + info.Name, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.UICancelOption.ThrowException);
					}
				}
			} catch (OperationCanceledException) {
				SCFiler2System.showTempMessage("t@C̈ړ̓LZ܂");
			}
		}

		/// <summary>
		/// File^̃XgAt@CpX̔zɕϊĕԂ
		/// </summary>
		/// <param name="item_list">File^̃Xg</param>
		/// <returns>string[]ɕϊz</returns>
		public static string[] getStringArrayFromFileList(List<FilerItem> item_list) {
			string[] str = new string[item_list.Count];
			for (int i = 0; i < item_list.Count; i++) {
				str[i] = item_list[i].Info.FullName;
			}
			return str;
		}

		/// <summary>
		/// t@CpX̔z񂩂AFileNX̃Xg𐶐
		/// </summary>
		/// <param name="files">t@C̃tpX̔z</param>
		/// <returns>̔zFile^ɕϊXg</returns>
		public static List<FilerItem> getFileListFromStringArray(string[] files) {
			List<FilerItem> list = new List<FilerItem>();
			for (int i = 0; i < files.Length; i++) {
				list.Add(FilerItem.createItem(files[i]));
			}
			return list;
		}
	}
}
