﻿using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class FileSearch : Action {
		public override string DisplayString {
			get { return "ファイル検索"; }
		}

		public override Action.ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType != MainForm.EFocusedViewType.FileView) {
				SCFiler2System.showTempMessage("ListViewにフォーカスがありません");
				return;
			}
			FileView view = main_form.getLastFocusedFileView();

			FileSearchForm form = new FileSearchForm(view.CurrentPath);
			System.Windows.Forms.DialogResult result = form.ShowDialog();
			if (result == System.Windows.Forms.DialogResult.Cancel) {
				SCFiler2System.showTempMessage("検索をキャンセルしました");
				return;
			}
			FilerItem item = form.SelectedItem;
			if (item != null) {
				if (item.Type == FilerItem.ItemType.Folder) {
					view.setPath(item.Info.FullName);
				} else {
					view.setPathAndFocusItem(item.Path, item.Info.FullName);
				}
			}
		}
	}
}
