using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.Util;

namespace SCFiler2.FileSystem {
	public class File : FilerItem {
		System.IO.FileInfo info;
		const long MB = 1024*1024;
		const long KB = 1024;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="full_name">t@CtpXŏ</param>
		public File(string full_name) {
			info = new System.IO.FileInfo(full_name);
		}

		override public System.IO.FileSystemInfo Info {
			get { return info; }
		}

		public override ItemType Type {
			get { return ItemType.File; }
		}

		public override string NameWithoutExtension {
			get { return System.IO.Path.GetFileNameWithoutExtension(info.FullName); }
		}

		public override string SizeDisplayString {
			get { 
				return DisplayUtil.sizeToString(info.Length);
			}
		}

		override public string Path {
			get { return System.IO.Path.GetDirectoryName(info.FullName); }
		}

		public long Size {
			get { return info.Length; }
		}
	}
}
