using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class CutToClipboard : Action {
		public override string DisplayString {
			get { return "Nbv{[hɐ؂"; }
		}

		public override Action.ActionType Type {
			get { return ActionType.FileOperation; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView view = main_form.getLastFocusedFileView();
				if (view.SelectedFilerItems.Count == 0) {
					SCFiler2System.showTempMessage("t@CIĂ܂");
					return;
				}

				ClipboardManager.sendToClipboard(ClipboardManager.EffectType.Cut, view.SelectedFilerItems);
				main_form.checkUpdateAllView();
				SCFiler2System.showTempMessage("IACeNbv{[hɐ؂܂");
			} else {
				//FileViewȊO͉Ȃ
				SCFiler2System.showTempMessage("FileViewɃtH[JXԂŎsĂ");
			}
		}
	}
}
