using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;
using SCFiler2.Util;

namespace SCFiler2.Action {
	public class Rename : Action {
		public override string DisplayString {
			get { return "O̕ύX"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType != MainForm.EFocusedViewType.FileView) {
				return;
			}
			FileView view = main_form.getLastFocusedFileView();
			List<FilerItem> items = view.SelectedFilerItems;
			if (items.Count == 0) {
				SCFiler2System.showTempMessage("t@CIĂ܂");
			} else if (items.Count > 1) {
				SCFiler2System.showTempMessage("t@CIĂ̂ŖO̕ύXsł܂");
			} else {
				FilerItem item = items[0];
				//VO̎擾
				InputTextForm form = new InputTextForm("O̕ύX", item.Info.Name);
				form.ShowDialog();
				if (form.DialogResult == System.Windows.Forms.DialogResult.Cancel) {
					SCFiler2System.showTempMessage("LZ܂");
				}
				string new_name = form.getInputtedText();

				//s
				if (item.Type == FilerItem.ItemType.File) {
					Microsoft.VisualBasic.FileIO.FileSystem.RenameFile(item.Info.FullName, new_name);
				} else {
					Microsoft.VisualBasic.FileIO.FileSystem.RenameDirectory(item.Info.FullName, new_name);
				}
				SCFiler2System.showTempMessage(item.Info.Name + "  " + new_name + "ɕύX܂");
				view.updateView();
			}
		}
	}
}
