﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SCFiler2.FileSystem;

namespace SCFiler2 {
	/// <summary>
	/// DialogResultがOKのとき、プロパティSelectedItemで検索結果のFilerItemが取得できる
	/// </summary>
	public partial class FileSearchForm : Form {
		string base_folder;
		FilerItem selected_item = null;
		public FilerItem SelectedItem {
			get { return selected_item; }
		}

		public FileSearchForm(string base_folder) {
			InitializeComponent();
			this.base_folder = base_folder;
			this.search_path_label.Text = "検索対象： " + base_folder;
		}

		public void execute() {
			found_item_list.Items.Clear();
			search(base_folder, search_string_text.Text);
			if (found_item_list.Items.Count > 0) {
				found_item_list.Items[0].Selected = true;
				found_item_list.Items[0].Focused = true;
			}
		}

		private void search(string search_path, string search_name) {
			string[] folders = System.IO.Directory.GetDirectories(search_path);
			foreach (string folder in folders) {
				string name = System.IO.Path.GetFileName(folder);
				if (name.IndexOf(search_name) >= 0) {
					item_found(new Folder(folder));
				}
				search(folder, search_name);
			}

			string[] files = System.IO.Directory.GetFiles(search_path);
			foreach (string file in files) {
				string name = System.IO.Path.GetFileName(file);
				if (name.IndexOf(search_name) >= 0) {
					item_found(new File(file));
				}
			}
		}

		private void item_found(FilerItem item) {
			ListViewItem view_item = new ListViewItem(item.Info.Name);
			view_item.SubItems.Add(item.Info.FullName);
			view_item.Tag = item;
			found_item_list.Items.Add(view_item);
		}

		private void button2_Click(object sender, EventArgs e) {
			Close();
		}

		private void search_button_Click(object sender, EventArgs e) {
			execute();
			found_item_list.Focus();
		}

		private void found_item_list_SelectedIndexChanged(object sender, EventArgs e) {
			if (found_item_list.SelectedItems.Count == 0) {
				return;
			}
			FilerItem item = (FilerItem)found_item_list.SelectedItems[0].Tag;
			if (item.Type == FilerItem.ItemType.File) {
				fullname_label.Text = item.Info.FullName;
				size_label.Text = item.SizeDisplayString;
				update_date_label.Text = item.Info.LastWriteTime.ToString("yyyy/MM/dd hh/mm/ss");
			} else {
				fullname_label.Text = item.Info.FullName;
				size_label.Text = "";
				update_date_label.Text = item.Info.LastWriteTime.ToString("yyyy/MM/dd hh/mm/ss");
			}
		}

		private void found_item_list_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				selected_item = (FilerItem)found_item_list.SelectedItems[0].Tag;
				this.DialogResult = DialogResult.OK;
				Close();
			}
		}

		private void FileSearchForm_MouseDoubleClick(object sender, MouseEventArgs e) {
			selected_item = (FilerItem)found_item_list.SelectedItems[0].Tag;
			Close();
		}

		private void search_string_text_TextChanged(object sender, EventArgs e) {

		}

		private void search_string_text_KeyDown(object sender, KeyEventArgs e) {
			if (e.KeyData == Keys.Enter) {
				execute();
				found_item_list.Focus();
			}
		}

		private void toolStripStatusLabel2_Click(object sender, EventArgs e) {

		}

		private void ok_button_Click(object sender, EventArgs e) {
			selected_item = (FilerItem)found_item_list.SelectedItems[0].Tag;
			this.DialogResult = DialogResult.OK;
			Close();
		}
	}
}